/*
 * Decompiled with CFR 0.152.
 */
package com.v1993.galacticcomputers.gcplanets;

import com.v1993.galacticcomputers.utils.NamedManagedEnvironment;
import java.lang.reflect.Method;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTelepadFake;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverTelepad
extends DriverSidedBlock {
    public DriverTelepad() {
        super(new ItemStack[0]);
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        Class<?> tileEntityClass = tileEntity.getClass();
        return TileEntityShortRangeTelepad.class.isAssignableFrom(tileEntityClass) || TileEntityTelepadFake.class.isAssignableFrom(tileEntityClass);
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        TileEntityShortRangeTelepad telepad;
        TileEntity tile = world.func_175625_s(pos);
        if (TileEntityShortRangeTelepad.class.isAssignableFrom(tile.getClass())) {
            telepad = (TileEntityShortRangeTelepad)tile;
        } else {
            try {
                Method getBaseTelepad = TileEntityTelepadFake.class.getDeclaredMethod("getBaseTelepad", new Class[0]);
                getBaseTelepad.setAccessible(true);
                telepad = (TileEntityShortRangeTelepad)getBaseTelepad.invoke((Object)tile, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return telepad != null ? new InternalManagedEnvironment(telepad) : null;
    }

    public static class InternalManagedEnvironment
    extends NamedManagedEnvironment<TileEntityShortRangeTelepad> {
        public InternalManagedEnvironment(TileEntityShortRangeTelepad tileEntity) {
            super(tileEntity, "telepad");
        }

        @Callback(doc="function(): number -- Get telepad's own address")
        public Object[] getAddress(Context context, Arguments args) {
            return new Object[]{((TileEntityShortRangeTelepad)this.tileEntity).address};
        }

        @Callback(doc="function(number: frequency) -- Set telepad's own address")
        public Object[] setAddress(Context context, Arguments args) {
            ((TileEntityShortRangeTelepad)this.tileEntity).setAddress(args.checkInteger(0));
            return new Object[0];
        }

        @Callback(doc="function(): boolean -- Check if telepad's own address is valid (nonnegative and unique)")
        public Object[] isAddressValid(Context context, Arguments args) {
            return new Object[]{((TileEntityShortRangeTelepad)this.tileEntity).addressValid};
        }

        @Callback(doc="function(): number -- Get telepad's destination address")
        public Object[] getTargetAddress(Context context, Arguments args) {
            return new Object[]{((TileEntityShortRangeTelepad)this.tileEntity).targetAddress};
        }

        @Callback(doc="function(number: frequency) -- Set telepad's destination address")
        public Object[] setTargetAddress(Context context, Arguments args) {
            ((TileEntityShortRangeTelepad)this.tileEntity).setTargetAddress(args.checkInteger(0));
            return new Object[0];
        }

        @Callback(doc="function(): boolean, string -- Check if telepad's destination address is valid (with description string)")
        public Object[] getTargetStatus(Context context, Arguments args) {
            switch (((TileEntityShortRangeTelepad)this.tileEntity).targetAddressResult) {
                case VALID: {
                    return new Object[]{true, "SUCCESS"};
                }
                case NOT_FOUND: {
                    return new Object[]{false, "NOT_FOUND"};
                }
                case TOO_FAR: 
                case WRONG_DIM: {
                    return new Object[]{false, "TOO_FAR"};
                }
                case TARGET_DISABLED: {
                    return new Object[]{false, "TARGET_DISABLED"};
                }
            }
            return new Object[]{false, "UNKNOWN"};
        }

        @Callback(doc="function(): boolean -- Check if telepad's enabled")
        public Object[] isEnabled(Context context, Arguments args) {
            return new Object[]{!((TileEntityShortRangeTelepad)this.tileEntity).disabled};
        }

        @Callback(doc="function(enabled: boolean) -- Enable or disable telepad")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityShortRangeTelepad)this.tileEntity).disabled = !args.checkBoolean(0);
            return new Object[0];
        }
    }
}

