/*
 * Decompiled with CFR 0.152.
 */
package com.v1993.galacticcomputers.gcplanets;

import com.v1993.galacticcomputers.utils.NamedManagedEnvironment;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayController;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverSolarArray
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileEntitySolarArrayController.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        TileEntitySolarArrayController tile = (TileEntitySolarArrayController)world.func_175625_s(pos);
        return new InternalManagedEnvironment(tile);
    }

    public static class InternalManagedEnvironment
    extends NamedManagedEnvironment<TileEntitySolarArrayController> {
        public InternalManagedEnvironment(TileEntitySolarArrayController tileEntity) {
            super(tileEntity, "solar_array");
        }

        @Callback(doc="function(): number -- Energy being produced per tick")
        public Object[] getEnergyProduction(Context context, Arguments args) {
            return new Object[]{((TileEntitySolarArrayController)this.tileEntity).generateWatts};
        }

        @Callback(doc="function(): boolean -- Is energy production enabled")
        public Object[] isEnabled(Context context, Arguments args) {
            return new Object[]{!((TileEntitySolarArrayController)this.tileEntity).getDisabled(0)};
        }

        @Callback(doc="function(boolean: enable) -- Enable/disable energy production")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntitySolarArrayController)this.tileEntity).setDisabled(0, !args.checkBoolean(0));
            return new Object[0];
        }

        @Callback(doc="function(): string -- Get current status of solar array (see docs for possible values)")
        public Object[] getStatus(Context context, Arguments args) {
            int panelsAttached = ((TileEntitySolarArrayController)this.tileEntity).getPossibleArraySize();
            int panelsActive = ((TileEntitySolarArrayController)this.tileEntity).getActualArraySize();
            if (((TileEntitySolarArrayController)this.tileEntity).getDisabled(0)) {
                return new Object[]{"DISABLED"};
            }
            if (panelsAttached == 0) {
                return new Object[]{"NO_PANELS"};
            }
            if (!((TileEntitySolarArrayController)this.tileEntity).func_145831_w().func_72935_r()) {
                return new Object[]{"NIGHT_TIME"};
            }
            if (((TileEntitySolarArrayController)this.tileEntity).func_145831_w().func_72896_J() || ((TileEntitySolarArrayController)this.tileEntity).func_145831_w().func_72911_I()) {
                return new Object[]{"RAINING"};
            }
            if (panelsActive == 0) {
                return new Object[]{"BLOCKED_FULLY"};
            }
            if (panelsActive < panelsAttached) {
                return new Object[]{"BLOCKED_PARTIALLY"};
            }
            if (((TileEntitySolarArrayController)this.tileEntity).generateWatts > 0) {
                return new Object[]{"GENERATING"};
            }
            return new Object[]{"UNKNOWN"};
        }

        @Callback(doc="function(): number -- Get solar boost")
        public Object[] getBoost(Context context, Arguments args) {
            return new Object[]{Float.valueOf((float)Math.round((((TileEntitySolarArrayController)this.tileEntity).getSolarBoost() - 1.0f) * 1000.0f) / 10.0f)};
        }
    }
}

