/*
 * Decompiled with CFR 0.152.
 */
package com.v1993.galacticcomputers.gcplanets;

import com.v1993.galacticcomputers.utils.NamedManagedEnvironment;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverLaunchController
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileEntityLaunchController.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        return new InternalManagedEnvironment((TileEntityLaunchController)world.func_175625_s(pos));
    }

    public static class InternalManagedEnvironment
    extends NamedManagedEnvironment<TileEntityLaunchController> {
        public InternalManagedEnvironment(TileEntityLaunchController tileEntity) {
            super(tileEntity, "launch_controller");
        }

        @Callback(doc="function(): number -- Get controller's own frequency")
        public Object[] getFrequency(Context context, Arguments args) {
            int frequency = ((TileEntityLaunchController)this.tileEntity).frequency;
            return new Object[]{frequency};
        }

        @Callback(doc="function(number: frequency) -- Set controller's own frequency")
        public Object[] setFrequency(Context context, Arguments args) {
            int frequency = args.checkInteger(0);
            ((TileEntityLaunchController)this.tileEntity).setFrequency(frequency);
            return new Object[0];
        }

        @Callback(doc="function(): boolean -- Check if controller's own frequency is valid (nonnegative and unique)")
        public Object[] isFrequencyValid(Context context, Arguments args) {
            return new Object[]{((TileEntityLaunchController)this.tileEntity).frequencyValid};
        }

        @Callback(doc="function(): number -- Get controller's destination frequency")
        public Object[] getDestinationFrequency(Context context, Arguments args) {
            int destFrequency = ((TileEntityLaunchController)this.tileEntity).destFrequency;
            return new Object[]{destFrequency};
        }

        @Callback(doc="function(number: frequency) -- Set controller's destination frequency")
        public Object[] setDestinationFrequency(Context context, Arguments args) {
            int destFrequency = args.checkInteger(0);
            ((TileEntityLaunchController)this.tileEntity).setDestinationFrequency(destFrequency);
            return new Object[0];
        }

        @Callback(doc="function(): boolean -- Check if controller's destination frequency is valid")
        public Object[] isDestinationFrequencyValid(Context context, Arguments args) {
            return new Object[]{((TileEntityLaunchController)this.tileEntity).destFrequencyValid};
        }

        @Callback(doc="function(): boolean -- Check if controller's enabled")
        public Object[] isEnabled(Context context, Arguments args) {
            return new Object[]{!((TileEntityLaunchController)this.tileEntity).disabled};
        }

        @Callback(doc="function(enabled: boolean) -- Enable or disable controller")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityLaunchController)this.tileEntity).disabled = !args.checkBoolean(0);
            return new Object[0];
        }

        @Callback(doc="function(): boolean -- Check if auto luanch is enabled")
        public Object[] isAutolaunchEnabled(Context context, Arguments args) {
            return new Object[]{((TileEntityLaunchController)this.tileEntity).launchSchedulingEnabled};
        }

        @Callback(doc="function(enabled: boolean) -- Enable or disable auto launch")
        public Object[] setAutolaunchEnabled(Context context, Arguments args) {
            ((TileEntityLaunchController)this.tileEntity).setLaunchSchedulingEnabled(args.checkBoolean(0));
            return new Object[0];
        }

        private TileEntityLandingPad getLaunchPad() {
            return ((TileEntityLaunchController)this.tileEntity).attachedDock instanceof TileEntityLandingPad ? (TileEntityLandingPad)((TileEntityLaunchController)this.tileEntity).attachedDock : null;
        }

        private EntityAutoRocket getRocket() {
            TileEntityLandingPad pad = this.getLaunchPad();
            if (pad != null) {
                IDockable docked = pad.getDockedEntity();
                return docked instanceof EntityAutoRocket ? (EntityAutoRocket)docked : null;
            }
            return null;
        }

        private boolean isControllerOperational() {
            return !((TileEntityLaunchController)this.tileEntity).getDisabled(0) && ((TileEntityLaunchController)this.tileEntity).hasEnoughEnergyToRun;
        }

        @Callback(doc="function(): boolean -- Check if rocket is present on connected launch pad")
        public Object[] isRocketPresent(Context context, Arguments args) {
            EntityAutoRocket rocket = this.getRocket();
            return new Object[]{rocket != null};
        }

        @Callback(doc="function(): table or boolean[, string] -- Get information about rocket's fuel tank, returns false and message on error")
        public Object[] getRocketFuelTank(Context context, Arguments args) {
            EntityAutoRocket rocket = this.getRocket();
            if (rocket == null) {
                return new Object[]{false, "rocket not found"};
            }
            return new Object[]{rocket.fuelTank.getInfo()};
        }

        @Callback(doc="function(): number or boolean[, string] -- Get rocket's countdown in seconds (with fractional part), returns false and message on error")
        public Object[] getCountdown(Context context, Arguments args) {
            EntityAutoRocket rocket = this.getRocket();
            if (rocket == null) {
                return new Object[]{false, "rocket not found"};
            }
            return new Object[]{Float.valueOf((float)rocket.timeUntilLaunch / 20.0f)};
        }

        @Callback(doc="function(): boolean[, string] -- Check is rocket ignited, returns false and message on error (check if message is present to see if it was an error)")
        public Object[] isRocketIgnited(Context context, Arguments args) {
            EntityAutoRocket rocket = this.getRocket();
            if (rocket == null) {
                return new Object[]{false, "rocket not found"};
            }
            return new Object[]{rocket.launchPhase != 0};
        }

        @Callback(doc="function(): boolean[, string] -- Check it's a passenger (player) rocket, returns false and message on error (check if message is present to see if it was an error)")
        public Object[] isRocketPassenger(Context context, Arguments args) {
            EntityAutoRocket rocket = this.getRocket();
            if (rocket == null) {
                return new Object[]{false, "rocket not found"};
            }
            return new Object[]{rocket.isPlayerRocket()};
        }

        @Callback(doc="function([boolean: skipFuelCheck]): boolean, string -- Launch rocket, returns if launch succeeded and informational string. Skip fuel check at your own risk!")
        public Object[] launch(Context context, Arguments args) {
            boolean skipFuelCheck = args.optBoolean(0, false);
            if (((TileEntityLaunchController)this.tileEntity).getDisabled(0) || !((TileEntityLaunchController)this.tileEntity).hasEnoughEnergyToRun) {
                return new Object[]{false, "controller not operational"};
            }
            EntityAutoRocket rocket = this.getRocket();
            if (rocket == null) {
                return new Object[]{false, "rocket not found"};
            }
            if (rocket.launchPhase != 0) {
                return new Object[]{false, "rocket already ignited"};
            }
            if (!rocket.hasValidFuel()) {
                return new Object[]{false, "no fuel in rocket"};
            }
            if (!skipFuelCheck && rocket.fuelTank.getFluidAmount() <= rocket.getMaxFuel() * 2 / 5) {
                return new Object[]{false, "not enough fuel for safe launch"};
            }
            if (rocket.igniteWithResult()) {
                return new Object[]{true, "success"};
            }
            return new Object[]{false, "ignition failed"};
        }

        @Callback(doc="function(): string -- Get owner of the controller")
        public Object[] getOwner(Context context, Arguments args) {
            String owner = ((TileEntityLaunchController)this.tileEntity).getOwnerName();
            return new Object[]{owner};
        }

        @Callback(doc="function(): boolean -- Check if controller is fully working (configured, powered, etc.)")
        public Object[] isCargoReady(Context context, Arguments args) {
            return new Object[]{((TileEntityLaunchController)this.tileEntity).validFrequency()};
        }

        @Callback(doc="function(): boolean -- Check if controller can launch passenger rockets (powered and enabled)")
        public Object[] isOccupied(Context context, Arguments args) {
            return new Object[]{this.isControllerOperational()};
        }
    }
}

