/*
 * Decompiled with CFR 0.152.
 */
package com.v1993.galacticcomputers.galaxyspace;

import com.v1993.galacticcomputers.utils.NamedManagedEnvironment;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindGenerator;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverWindTurbine
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileEntityWindGenerator.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        TileEntityWindGenerator tile = (TileEntityWindGenerator)world.func_175625_s(pos);
        return new InternalManagedEnvironment(tile);
    }

    public static class InternalManagedEnvironment
    extends NamedManagedEnvironment<TileEntityWindGenerator> {
        public InternalManagedEnvironment(TileEntityWindGenerator tileEntity) {
            super(tileEntity, "wind_turbine");
        }

        @Callback(doc="function(): boolean -- Is energy production enabled")
        public Object[] isEnabled(Context context, Arguments args) {
            return new Object[]{!((TileEntityWindGenerator)this.tileEntity).getDisabled(0)};
        }

        @Callback(doc="function(boolean: enable) -- Enable/disable energy production")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityWindGenerator)this.tileEntity).setDisabled(0, !args.checkBoolean(0));
            return new Object[0];
        }

        @Callback(doc="function(): number -- Energy being produced per tick")
        public Object[] getEnergyProduction(Context context, Arguments args) {
            return new Object[]{Float.valueOf(((TileEntityWindGenerator)this.tileEntity).generateWatts)};
        }

        @Callback(doc="function(): string -- Get current status of wind turbine (see docs for possible values)")
        public Object[] getStatus(Context context, Arguments args) {
            if (((TileEntityWindGenerator)this.tileEntity).getDisabled(0)) {
                return new Object[]{"DISABLED"};
            }
            if (((TileEntityWindGenerator)this.tileEntity).generateWatts > 0.0f) {
                return new Object[]{"GENERATING"};
            }
            return new Object[]{"UNKNOWN"};
        }

        @Callback(doc="function(): number -- Get environmental boost")
        public Object[] getBoost(Context context, Arguments args) {
            return new Object[]{Float.valueOf((float)Math.round((((TileEntityWindGenerator)this.tileEntity).getWindBoost() - 1.0f) * 1000.0f) / 10.0f)};
        }
    }
}

