/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common.tileentity;

import com.nekokittygames.mffs.common.Linkgrid;
import com.nekokittygames.mffs.common.ModularForceFieldSystem;
import com.nekokittygames.mffs.common.NBTTagCompoundHelper;
import com.nekokittygames.mffs.common.SecurityRight;
import com.nekokittygames.mffs.common.container.ContainerAdvSecurityStation;
import com.nekokittygames.mffs.common.item.ItemAccessCard;
import com.nekokittygames.mffs.common.item.ItemCardEmpty;
import com.nekokittygames.mffs.common.item.ItemCardPersonalID;
import com.nekokittygames.mffs.common.item.ModItems;
import com.nekokittygames.mffs.common.multitool.ItemDebugger;
import com.nekokittygames.mffs.common.tileentity.TileEntityMachines;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TileEntityAdvSecurityStation
extends TileEntityMachines {
    private String MainUser = "";
    private boolean securityEstablished = false;

    public TileEntityAdvSecurityStation() {
        super(40);
    }

    @Override
    public void dropPlugins() {
        for (int a = 0; a < this.inventory.size(); ++a) {
            this.dropPlugins(a);
        }
    }

    public String getMainUser() {
        return this.MainUser;
    }

    public void setMainUser(String s) {
        if (!this.MainUser.equals(s)) {
            this.MainUser = s;
            this.func_70296_d();
        }
    }

    @Override
    public Container getContainer(InventoryPlayer inventoryplayer) {
        return new ContainerAdvSecurityStation(inventoryplayer.field_70458_d, this);
    }

    @Override
    public void func_145843_s() {
        Linkgrid.getWorldMap(this.field_145850_b).getSecStation().remove(this.getDeviceID());
        super.func_145843_s();
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getTicker() >= 10) {
                if (!this.getMainUser().equals("")) {
                    if (!this.isActive()) {
                        this.setActive(true);
                    }
                } else if (this.isActive()) {
                    this.setActive(false);
                }
                this.checkSlots();
                this.setTicker((short)0);
                this.securityEstablished = true;
            }
            this.setTicker((short)(this.getTicker() + 1));
        }
        super.func_73660_a();
    }

    public boolean isSecurityEstablished() {
        return this.securityEstablished;
    }

    public void checkSlots() {
        if (this.func_70301_a(0) != null) {
            if (this.func_70301_a(0).func_77973_b() == ModItems.PERSONAL_ID) {
                ItemCardPersonalID Card = (ItemCardPersonalID)this.func_70301_a(0).func_77973_b();
                String name = Card.getUUID(this.func_70301_a(0));
                if (!this.getMainUser().equals(name)) {
                    this.setMainUser(name);
                }
                if (!ItemCardPersonalID.hasRight(this.func_70301_a(0), SecurityRight.CSR)) {
                    ItemCardPersonalID.setRight(this.func_70301_a(0), SecurityRight.CSR, true);
                }
            } else {
                this.setMainUser("");
            }
        } else {
            this.setMainUser("");
        }
        if (this.func_70301_a(39) != null && this.func_70301_a(38) != null && this.func_70301_a(38).func_77973_b() instanceof ItemCardEmpty && this.func_70301_a(39).func_77973_b() instanceof ItemCardPersonalID) {
            this.func_70299_a(38, this.func_70301_a(39).func_77946_l());
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public String func_70005_c_() {
        return "Secstation";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean RemoteInventory(String username, SecurityRight right) {
        for (int a = 35; a >= 1; --a) {
            ItemStack stack = this.func_70301_a(a);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.PERSONAL_ID) continue;
            String username_invtory = NBTTagCompoundHelper.getTAGfromItemstack(stack).func_74779_i("name");
            ItemCardPersonalID Card = (ItemCardPersonalID)stack.func_77973_b();
            boolean access = ItemCardPersonalID.hasRight(stack, right);
            if (!username_invtory.equals(username)) continue;
            return access;
        }
        return false;
    }

    public boolean RemotePlayerInventory(String username, SecurityRight right) {
        EntityPlayer player = this.field_145850_b.func_72924_a(username);
        if (player != null) {
            List slots = player.field_71069_bz.field_75151_b;
            for (Slot slot : slots) {
                ItemStack stack = slot.func_75211_c();
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() instanceof ItemAccessCard) {
                    if (ItemAccessCard.getvalidity(stack) > 0) {
                        if (ItemAccessCard.getlinkID(stack) == this.getDeviceID() && ItemAccessCard.hasRight(stack, right)) {
                            if (!ItemAccessCard.getforAreaname(stack).equals(this.getDeviceName())) {
                                ItemAccessCard.setforArea(stack, this);
                            }
                            return true;
                        }
                    } else {
                        ItemStack Card = new ItemStack((Item)ModItems.EMPTY_CARD, 1);
                        slot.func_75215_d(Card);
                    }
                }
                if (!(stack.func_77973_b() instanceof ItemDebugger)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAccessGranted(String username, SecurityRight sr) {
        if (!this.isActive()) {
            return true;
        }
        String[] ops = ModularForceFieldSystem.Admin.split(";");
        EntityPlayer player = this.field_145850_b.func_72924_a(username);
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (int i = 0; i <= ops.length - 1; ++i) {
            if (!username.equalsIgnoreCase(ops[i])) continue;
            return true;
        }
        if (this.MainUser.equals(username)) {
            return true;
        }
        if (this.RemoteInventory(username, sr)) {
            return true;
        }
        return this.RemotePlayerInventory(username, sr);
    }

    @Override
    public List<String> getFieldsforUpdate() {
        LinkedList<String> NetworkedFields = new LinkedList<String>();
        NetworkedFields.clear();
        NetworkedFields.addAll(super.getFieldsforUpdate());
        NetworkedFields.add("MainUser");
        return NetworkedFields;
    }

    @Override
    public boolean isItemValid(ItemStack par1ItemStack, int Slot2) {
        switch (Slot2) {
            case 38: {
                if (par1ItemStack.func_77973_b() instanceof ItemCardEmpty) break;
                return false;
            }
            case 39: {
                if (!(par1ItemStack.func_77973_b() instanceof ItemAccessCard) && par1ItemStack.func_77973_b() instanceof ItemCardPersonalID) break;
                return false;
            }
        }
        return par1ItemStack.func_77973_b() instanceof ItemCardPersonalID || par1ItemStack.func_77973_b() instanceof ItemCardEmpty;
    }

    @Override
    public void onNetworkHandlerEvent(int key, String value) {
        ModularForceFieldSystem.log.info("Key: " + Integer.toString(key) + ". Value: " + value);
        switch (key) {
            case 100: {
                SecurityRight sr;
                if (this.func_70301_a(1).func_190926_b() || (sr = SecurityRight.rights.get(value)) == null || !(this.func_70301_a(1).func_77973_b() instanceof ItemCardPersonalID)) break;
                ItemCardPersonalID.setRight(this.func_70301_a(1), sr, !ItemCardPersonalID.hasRight(this.func_70301_a(1), sr));
                break;
            }
            case 101: {
                if (this.func_70301_a(1).func_190926_b() || !(this.func_70301_a(1).func_77973_b() instanceof ItemAccessCard)) break;
                if (ItemAccessCard.getvalidity(this.func_70301_a(1)) <= 5) {
                    this.func_70299_a(1, new ItemStack((Item)ModItems.EMPTY_CARD, 1));
                    break;
                }
                ItemAccessCard.setvalidity(this.func_70301_a(1), ItemAccessCard.getvalidity(this.func_70301_a(1)) - 5);
                break;
            }
            case 102: {
                if (this.func_70301_a(1).func_190926_b()) break;
                if (this.func_70301_a(1).func_77973_b() instanceof ItemCardEmpty) {
                    this.func_70299_a(1, new ItemStack((Item)ModItems.ACCESS_CARD, 1));
                    if (!(this.func_70301_a(1).func_77973_b() instanceof ItemAccessCard)) break;
                    ItemAccessCard.setforArea(this.func_70301_a(1), this);
                    ItemAccessCard.setvalidity(this.func_70301_a(1), 5);
                    ItemAccessCard.setlinkID(this.func_70301_a(1), this);
                    break;
                }
                if (!(this.func_70301_a(1).func_77973_b() instanceof ItemAccessCard)) break;
                ItemAccessCard.setvalidity(this.func_70301_a(1), ItemAccessCard.getvalidity(this.func_70301_a(1)) + 5);
            }
        }
        super.onNetworkHandlerEvent(key, value);
    }

    public ItemStack getModCardStack() {
        if (!this.func_70301_a(1).func_190926_b()) {
            return this.func_70301_a(1);
        }
        return null;
    }

    @Override
    public int getSlotStackLimit(int slt) {
        return 1;
    }

    @Override
    public TileEntityAdvSecurityStation getLinkedSecurityStation() {
        return this;
    }
}

