/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.hud;

import net.machinemuse.numina.client.render.MuseIconUtils;
import net.machinemuse.numina.client.render.MuseTextureUtils;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.math.Colour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.lwjgl.opengl.GL11;

public class HeatMeter {
    final int xsize = 32;
    final int ysize = 8;
    double meterStart;
    double meterLevel;
    double alpha;

    public double getAlpha() {
        return 0.7;
    }

    public Colour getColour() {
        return Colour.RED;
    }

    public TextureAtlasSprite getTexture() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/snow");
    }

    public void draw(double xpos, double ypos, double value) {
        MuseTextureUtils.pushTexture((String)"textures/atlas/blocks.png");
        RenderState.blendingOn();
        RenderState.on2D();
        this.drawFluid(xpos, ypos, value, this.getTexture());
        this.drawGlass(xpos, ypos);
        RenderState.off2D();
        RenderState.blendingOff();
        MuseTextureUtils.popTexture();
    }

    public void drawFluid(double xpos, double ypos, double value, TextureAtlasSprite icon) {
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        this.meterStart = xpos;
        this.meterLevel = xpos + 32.0 * value;
        while (this.meterStart + 8.0 < this.meterLevel) {
            MuseIconUtils.drawIconAt((double)(this.meterStart * 2.0), (double)(ypos * 2.0), (TextureAtlasSprite)icon, (Colour)this.getColour().withAlpha(this.getAlpha()));
            this.meterStart += 8.0;
        }
        MuseIconUtils.drawIconPartial((double)(this.meterStart * 2.0), (double)(ypos * 2.0), (TextureAtlasSprite)icon, (Colour)this.getColour().withAlpha(this.getAlpha()), (double)0.0, (double)0.0, (double)((this.meterLevel - this.meterStart) * 2.0), (double)16.0);
        GL11.glPopMatrix();
    }

    public void drawGlass(double xpos, double ypos) {
        MuseTextureUtils.pushTexture((String)"powersuits:textures/gui/glass.png");
        Colour.WHITE.doGL();
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)xpos, (double)ypos);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)(xpos + 32.0), (double)ypos);
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex2d((double)(xpos + 32.0), (double)(ypos + 8.0));
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)xpos, (double)(ypos + 8.0));
        GL11.glEnd();
        MuseTextureUtils.popTexture();
    }
}

