/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityTools {
    public static boolean hasItemCapabilitySafe(TileEntity tileEntity) {
        try {
            return tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        catch (RuntimeException e) {
            CapabilityTools.reportWrongBlock(tileEntity, e);
            return false;
        }
    }

    public static IItemHandler getItemCapabilitySafe(TileEntity tileEntity) {
        try {
            return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        catch (RuntimeException e) {
            CapabilityTools.reportWrongBlock(tileEntity, e);
            return null;
        }
    }

    public static IFluidHandler hasFluidCapabilitySafe(TileEntity tileEntity) {
        try {
            if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IFluidHandler capability = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (capability == null) {
                    CapabilityTools.reportWrongBlock(tileEntity, null);
                }
                return capability;
            }
            return null;
        }
        catch (RuntimeException e) {
            CapabilityTools.reportWrongBlock(tileEntity, e);
            return null;
        }
    }

    public static IFluidHandler getFluidCapabilitySafe(TileEntity tileEntity) {
        try {
            return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        }
        catch (RuntimeException e) {
            CapabilityTools.reportWrongBlock(tileEntity, e);
            return null;
        }
    }

    private static void reportWrongBlock(TileEntity tileEntity, Exception e) {
        if (tileEntity != null) {
            ResourceLocation name = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v()).func_177230_c().getRegistryName();
            Logging.logError("Block " + name.toString() + " at " + BlockPosTools.toString(tileEntity.func_174877_v()) + " does not respect the capability API and crashes on null side.");
            Logging.logError("Please report to the corresponding mod. This is not a bug in RFTools!");
        }
        if (e != null) {
            Logging.logError("Exception", e);
        }
    }
}

