/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import net.minecraft.nbt.NBTTagCompound;

public class McJtyEnergyStorage {
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;

    public McJtyEnergyStorage(long capacity) {
        this(capacity, capacity, capacity, 0L);
    }

    public McJtyEnergyStorage(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0L);
    }

    public McJtyEnergyStorage(long capacity, long maxReceive, long maxExtract) {
        this(capacity, maxReceive, maxExtract, 0L);
    }

    public McJtyEnergyStorage(long capacity, long maxReceive, long maxExtract, long energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0L, Math.min(capacity, energy));
    }

    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public long getEnergyStored() {
        return this.energy;
    }

    public long getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0L;
    }

    public boolean canReceive() {
        return this.maxReceive > 0L;
    }

    public void modifyEnergyStored(long energy) {
        if (energy > this.capacity - this.energy) {
            energy = this.capacity - this.energy;
        } else if (energy < -this.energy) {
            energy = -this.energy;
        }
        this.energy += energy;
    }

    public void setMaxReceive(long max) {
        this.maxReceive = max;
    }

    public void setMaxExtract(long max) {
        this.maxExtract = max;
    }

    public McJtyEnergyStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74763_f("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0L) {
            this.energy = 0L;
        }
        nbt.func_74772_a("Energy", this.energy);
        return nbt;
    }
}

