/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.util;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.NonNullArrayIterator;
import com.google.common.collect.ImmutableSet;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.github.phantamanta44.libnine.util.ImpossibilityRealizedException;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class ThrEngCraftingTracker
implements ISerializable {
    private final ICraftingRequester owner;
    private final Future<ICraftingJob>[] jobs;
    private final ICraftingLink[] links;
    private final TObjectIntMap<ICraftingLink> linksInv;

    public ThrEngCraftingTracker(ICraftingRequester owner, int size) {
        this.owner = owner;
        this.jobs = new Future[size];
        this.links = new ICraftingLink[size];
        this.linksInv = new TObjectIntHashMap(size * 2 + 1, 0.8f, -1);
    }

    public boolean requestCrafting(int slot, IAEItemStack item, World world, IGrid grid, ICraftingGrid crafting, IActionSource actionSrc) {
        if (this.links[slot] != null) {
            return false;
        }
        Future<ICraftingJob> jobTask = this.jobs[slot];
        if (jobTask == null) {
            this.jobs[slot] = crafting.beginCraftingJob(world, grid, actionSrc, item.copy(), null);
        } else if (jobTask.isDone()) {
            try {
                ICraftingJob job = jobTask.get();
                if (job != null) {
                    ICraftingLink link = crafting.submitJob(job, this.owner, null, false, actionSrc);
                    this.jobs[slot] = null;
                    if (link != null) {
                        this.links[slot] = link;
                        this.linksInv.put((Object)link, slot);
                        this.updateLinks();
                        return true;
                    }
                }
            }
            catch (ExecutionException e) {
                return false;
            }
            catch (InterruptedException e) {
                throw new ImpossibilityRealizedException((Throwable)e);
            }
        }
        return false;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return ImmutableSet.copyOf((Iterator)new NonNullArrayIterator((Object[])this.links));
    }

    public int getSlotForJob(ICraftingLink link) {
        return this.linksInv.get((Object)link);
    }

    public boolean isSlotOpen(int slot) {
        return this.links[slot] == null;
    }

    public boolean onJobStateChange(ICraftingLink link) {
        int slot = this.linksInv.remove((Object)link);
        if (slot == -1) {
            return false;
        }
        this.links[slot] = null;
        this.updateLinks();
        return true;
    }

    private void updateLinks() {
        for (int i = 0; i < this.links.length; ++i) {
            if (this.links[i] == null || !this.links[i].isCanceled() && !this.links[i].isDone()) continue;
            this.linksInv.remove((Object)this.links[i]);
            this.links[i] = null;
        }
    }

    public void serBytes(ByteUtils.Writer data) {
        int mask = 0;
        for (int i = 0; i < this.links.length; ++i) {
            if (this.links[i] == null) continue;
            mask |= 1 << i;
        }
        data.writeVarPrecision(mask);
        for (ICraftingLink link : this.links) {
            if (link == null) continue;
            NBTTagCompound dto = new NBTTagCompound();
            link.writeToNBT(dto);
            data.writeTagCompound(dto);
        }
    }

    public void deserBytes(ByteUtils.Reader data) {
        this.linksInv.clear();
        int mask = data.readVarPrecision();
        for (int i = 0; i < this.links.length; ++i) {
            if ((mask & 1 << i) != 0) {
                ICraftingLink link;
                this.links[i] = link = AEApi.instance().storage().loadCraftingLink(data.readTagCompound(), this.owner);
                this.linksInv.put((Object)link, i);
                continue;
            }
            this.links[i] = null;
        }
    }

    public void serNBT(NBTTagCompound tag) {
        NBTTagList linksDto = new NBTTagList();
        for (ICraftingLink link : this.links) {
            NBTTagCompound linkDto = new NBTTagCompound();
            if (link != null) {
                link.writeToNBT(linkDto);
            }
            linksDto.func_74742_a((NBTBase)linkDto);
        }
        tag.func_74782_a("Links", (NBTBase)linksDto);
    }

    public void deserNBT(NBTTagCompound tag) {
        this.linksInv.clear();
        NBTTagList linksDto = tag.func_150295_c("Links", 10);
        for (int i = 0; i < this.links.length; ++i) {
            ICraftingLink link;
            NBTTagCompound linkDto = linksDto.func_150305_b(i);
            if (linkDto.func_82582_d()) {
                this.links[i] = null;
                continue;
            }
            this.links[i] = link = AEApi.instance().storage().loadCraftingLink(linkDto, this.owner);
            this.linksInv.put((Object)link, i);
        }
    }
}

