/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.integration.jei;

import crafttweaker.annotations.ModOnly;
import io.github.phantamanta44.threng.client.gui.GuiEnergizer;
import io.github.phantamanta44.threng.constant.ResConst;
import io.github.phantamanta44.threng.integration.jei.base.ThrEngJeiCategory;
import io.github.phantamanta44.threng.recipe.EnergizeRecipe;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.TickTimer;
import net.minecraft.client.Minecraft;

@ModOnly(value="jei")
class JeiRecipeTypeEnergize
extends ThrEngJeiCategory<EnergizeRecipe, Recipe> {
    private final ITickTimer animator = new TickTimer(32, 32, false);

    JeiRecipeTypeEnergize() {
        super(EnergizeRecipe.class, "threng.energize", "threng.int.jei.category.energizer", ResConst.INT_JEI_CAT_ENERGIZE_BG);
    }

    public void setRecipe(IRecipeLayout layout, Recipe recipe, IIngredients ingredients) {
        layout.getItemStacks().init(0, true, 4, 8);
        layout.getItemStacks().init(1, false, 64, 8);
        layout.getItemStacks().set(ingredients);
    }

    @Override
    public Recipe wrap(EnergizeRecipe recipe) {
        return new Recipe(recipe);
    }

    public void drawExtras(Minecraft minecraft) {
        GuiEnergizer.drawProgressBar(30, 3, (float)this.animator.getValue() / (float)this.animator.getMaxValue());
    }

    static class Recipe
    implements IRecipeWrapper {
        private final EnergizeRecipe recipe;

        Recipe(EnergizeRecipe recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, this.recipe.input().getMatcher().getVisuals());
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.getOutput().getOutput());
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            minecraft.field_71466_p.func_175063_a(String.format("%,d FE", this.recipe.input().getEnergy()), 3.0f, 36.0f, -1);
        }
    }
}

