/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.text.serializer.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import me.lucko.spark.lib.adventure.key.Key;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.event.ClickEvent;
import me.lucko.spark.lib.adventure.text.event.HoverEvent;
import me.lucko.spark.lib.adventure.text.format.Style;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.lib.adventure.text.format.TextDecoration;
import me.lucko.spark.lib.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import me.lucko.spark.lib.adventure.text.serializer.gson.TextColorWrapper;
import me.lucko.spark.lib.adventure.util.Codec;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StyleSerializer
implements JsonDeserializer<Style>,
JsonSerializer<Style> {
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    static final String FONT = "font";
    static final String COLOR = "color";
    static final String INSERTION = "insertion";
    static final String CLICK_EVENT = "clickEvent";
    static final String CLICK_EVENT_ACTION = "action";
    static final String CLICK_EVENT_VALUE = "value";
    static final String HOVER_EVENT = "hoverEvent";
    static final String HOVER_EVENT_ACTION = "action";
    static final String HOVER_EVENT_CONTENTS = "contents";
    @Deprecated
    static final String HOVER_EVENT_VALUE = "value";
    private final LegacyHoverEventSerializer legacyHover;
    private final boolean emitLegacyHover;

    StyleSerializer(@Nullable LegacyHoverEventSerializer legacyHover, boolean emitLegacyHover) {
        this.legacyHover = legacyHover;
        this.emitLegacyHover = emitLegacyHover;
    }

    public Style deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        return this.deserialize(object, context);
    }

    private Style deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        JsonObject hoverEvent;
        ClickEvent.Action action;
        JsonObject clickEvent;
        Style.Builder style = Style.style();
        if (json.has(FONT)) {
            style.font((Key)context.deserialize(json.get(FONT), Key.class));
        }
        if (json.has(COLOR)) {
            TextColorWrapper color = (TextColorWrapper)context.deserialize(json.get(COLOR), TextColorWrapper.class);
            if (color.color != null) {
                style.color(color.color);
            } else if (color.decoration != null) {
                style.decoration(color.decoration, true);
            }
        }
        for (TextDecoration decoration : DECORATIONS) {
            String name = TextDecoration.NAMES.key(decoration);
            if (!json.has(name)) continue;
            style.decoration(decoration, json.get(name).getAsBoolean());
        }
        if (json.has(INSERTION)) {
            style.insertion(json.get(INSERTION).getAsString());
        }
        if (json.has(CLICK_EVENT) && (clickEvent = json.getAsJsonObject(CLICK_EVENT)) != null && (action = StyleSerializer.optionallyDeserialize((JsonElement)clickEvent.getAsJsonPrimitive("action"), context, ClickEvent.Action.class)) != null && action.readable()) {
            String value;
            JsonPrimitive rawValue = clickEvent.getAsJsonPrimitive("value");
            String string = value = rawValue == null ? null : rawValue.getAsString();
            if (value != null) {
                style.clickEvent(ClickEvent.clickEvent(action, value));
            }
        }
        if (json.has(HOVER_EVENT) && (hoverEvent = json.getAsJsonObject(HOVER_EVENT)) != null && (action = StyleSerializer.optionallyDeserialize((JsonElement)hoverEvent.getAsJsonPrimitive("action"), context, HoverEvent.Action.class)) != null && action.readable()) {
            Object value;
            Object rawValue;
            if (hoverEvent.has(HOVER_EVENT_CONTENTS)) {
                rawValue = hoverEvent.get(HOVER_EVENT_CONTENTS);
                value = context.deserialize(rawValue, action.type());
            } else if (hoverEvent.has("value")) {
                rawValue = (Component)context.deserialize(hoverEvent.get("value"), Component.class);
                value = this.legacyHoverEventContents(action, (Component)rawValue, context);
            } else {
                value = null;
            }
            if (value != null) {
                style.hoverEvent(HoverEvent.hoverEvent(action, value));
            }
        }
        if (json.has(FONT)) {
            style.font((Key)context.deserialize(json.get(FONT), Key.class));
        }
        return style.build();
    }

    private static <T> T optionallyDeserialize(JsonElement json, JsonDeserializationContext context, Class<T> type) {
        return (T)(json == null ? null : context.deserialize(json, type));
    }

    private Object legacyHoverEventContents(HoverEvent.Action<?> action, Component rawValue, JsonDeserializationContext context) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return rawValue;
        }
        if (this.legacyHover != null) {
            try {
                if (action == HoverEvent.Action.SHOW_ENTITY) {
                    return this.legacyHover.deserializeShowEntity(rawValue, this.decoder(context));
                }
                if (action == HoverEvent.Action.SHOW_ITEM) {
                    return this.legacyHover.deserializeShowItem(rawValue);
                }
            }
            catch (IOException ex) {
                throw new JsonParseException((Throwable)ex);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Codec.Decoder<Component, String, JsonParseException> decoder(JsonDeserializationContext ctx) {
        return string -> {
            JsonReader reader = new JsonReader((Reader)new StringReader((String)string));
            return (Component)ctx.deserialize(Streams.parse((JsonReader)reader), Component.class);
        };
    }

    public JsonElement serialize(Style src, Type typeOfSrc, JsonSerializationContext context) {
        HoverEvent<?> hoverEvent;
        ClickEvent clickEvent;
        TextColor color;
        JsonObject json = new JsonObject();
        Key font = src.font();
        if (font != null) {
            json.add(FONT, context.serialize((Object)font));
        }
        if ((color = src.color()) != null) {
            json.add(COLOR, context.serialize((Object)color));
        }
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State state = src.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) continue;
            String name = TextDecoration.NAMES.key(decoration);
            assert (name != null);
            json.addProperty(name, Boolean.valueOf(state == TextDecoration.State.TRUE));
        }
        String insertion = src.insertion();
        if (insertion != null) {
            json.addProperty(INSERTION, insertion);
        }
        if ((clickEvent = src.clickEvent()) != null) {
            JsonObject eventJson = new JsonObject();
            eventJson.add("action", context.serialize((Object)clickEvent.action()));
            eventJson.addProperty("value", clickEvent.value());
            json.add(CLICK_EVENT, (JsonElement)eventJson);
        }
        if ((hoverEvent = src.hoverEvent()) != null) {
            JsonObject eventJson = new JsonObject();
            eventJson.add("action", context.serialize(hoverEvent.action()));
            JsonElement modernContents = context.serialize(hoverEvent.value());
            eventJson.add(HOVER_EVENT_CONTENTS, modernContents);
            if (this.emitLegacyHover) {
                eventJson.add("value", this.serializeLegacyHoverEvent(hoverEvent, modernContents, context));
            }
            json.add(HOVER_EVENT, (JsonElement)eventJson);
        }
        return json;
    }

    private JsonElement serializeLegacyHoverEvent(HoverEvent<?> hoverEvent, JsonElement modernContents, JsonSerializationContext context) {
        if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
            return modernContents;
        }
        if (this.legacyHover != null) {
            Component serialized = null;
            try {
                if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
                    serialized = this.legacyHover.serializeShowEntity((HoverEvent.ShowEntity)hoverEvent.value(), this.encoder(context));
                } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
                    serialized = this.legacyHover.serializeShowItem((HoverEvent.ShowItem)hoverEvent.value());
                }
            }
            catch (IOException ex) {
                throw new JsonSyntaxException((Throwable)ex);
            }
            return serialized == null ? JsonNull.INSTANCE : context.serialize((Object)serialized);
        }
        return JsonNull.INSTANCE;
    }

    private Codec.Encoder<Component, String, RuntimeException> encoder(JsonSerializationContext ctx) {
        return component -> ctx.serialize(component).toString();
    }
}

