/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.text.feature.pagination;

import java.util.function.Consumer;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.feature.pagination.Pagination;
import me.lucko.spark.lib.adventure.text.feature.pagination.PaginationImpl;
import me.lucko.spark.lib.adventure.text.format.Style;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

final class PaginationBuilder
implements Pagination.Builder {
    private int width = 55;
    private int resultsPerPage = 6;
    private char lineCharacter = (char)45;
    private Style lineStyle = Pagination.LINE_STYLE;
    private Pagination.Renderer renderer = Pagination.DEFAULT_RENDERER;
    private char previousPageButtonCharacter = (char)171;
    private Style previousPageButtonStyle = Pagination.PREVIOUS_PAGE_BUTTON_STYLE;
    private char nextPageButtonCharacter = (char)187;
    private Style nextPageButtonStyle = Pagination.NEXT_PAGE_BUTTON_STYLE;

    PaginationBuilder() {
    }

    @Override
    public @NonNull Pagination.Builder width(int width) {
        this.width = width;
        return this;
    }

    @Override
    public @NonNull Pagination.Builder resultsPerPage(@NonNegative int resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
        return this;
    }

    @Override
    public @NonNull Pagination.Builder renderer(@NonNull Pagination.Renderer renderer) {
        this.renderer = renderer;
        return this;
    }

    @Override
    public @NonNull Pagination.Builder line(@NonNull Consumer<Pagination.Builder.CharacterAndStyle> line) {
        line.accept(new Pagination.Builder.CharacterAndStyle(){

            @Override
            public @NonNull Pagination.Builder.CharacterAndStyle character(char character) {
                PaginationBuilder.this.lineCharacter = character;
                return this;
            }

            @Override
            public @NonNull Pagination.Builder.CharacterAndStyle style(@NonNull Style style) {
                PaginationBuilder.this.lineStyle = style;
                return this;
            }
        });
        return this;
    }

    @Override
    public @NonNull Pagination.Builder previousButton(@NonNull Consumer<Pagination.Builder.CharacterAndStyle> previousButton) {
        previousButton.accept(new Pagination.Builder.CharacterAndStyle(){

            @Override
            public @NonNull Pagination.Builder.CharacterAndStyle character(char character) {
                PaginationBuilder.this.previousPageButtonCharacter = character;
                return this;
            }

            @Override
            public @NonNull Pagination.Builder.CharacterAndStyle style(@NonNull Style style) {
                PaginationBuilder.this.previousPageButtonStyle = style;
                return this;
            }
        });
        return this;
    }

    @Override
    public @NonNull Pagination.Builder nextButton(@NonNull Consumer<Pagination.Builder.CharacterAndStyle> nextButton) {
        nextButton.accept(new Pagination.Builder.CharacterAndStyle(){

            @Override
            public @NonNull Pagination.Builder.CharacterAndStyle character(char character) {
                PaginationBuilder.this.nextPageButtonCharacter = character;
                return this;
            }

            @Override
            public @NonNull Pagination.Builder.CharacterAndStyle style(@NonNull Style style) {
                PaginationBuilder.this.nextPageButtonStyle = style;
                return this;
            }
        });
        return this;
    }

    @Override
    public <T> @NonNull Pagination<T> build(@NonNull Component title, @NonNull Pagination.Renderer.RowRenderer<T> rowRenderer, @NonNull Pagination.PageCommandFunction pageCommand) {
        return new PaginationImpl<T>(this.width, this.resultsPerPage, this.renderer, this.lineCharacter, this.lineStyle, this.previousPageButtonCharacter, this.previousPageButtonStyle, this.nextPageButtonCharacter, this.nextPageButtonStyle, title, rowRenderer, pageCommand);
    }
}

