/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.text;

import java.util.regex.Matcher;
import me.lucko.spark.lib.adventure.examination.Examinable;
import me.lucko.spark.lib.adventure.text.BlockNBTComponentImpl;
import me.lucko.spark.lib.adventure.text.NBTComponent;
import me.lucko.spark.lib.adventure.text.NBTComponentBuilder;
import me.lucko.spark.lib.adventure.text.ScopedComponent;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface BlockNBTComponent
extends NBTComponent<BlockNBTComponent, Builder>,
ScopedComponent<BlockNBTComponent> {
    public @NonNull Pos pos();

    public @NonNull BlockNBTComponent pos(@NonNull Pos var1);

    default public @NonNull BlockNBTComponent localPos(double left, double up, double forwards) {
        return this.pos(LocalPos.of(left, up, forwards));
    }

    default public @NonNull BlockNBTComponent worldPos(@NonNull WorldPos.Coordinate x, @NonNull WorldPos.Coordinate y, @NonNull WorldPos.Coordinate z) {
        return this.pos(WorldPos.of(x, y, z));
    }

    default public @NonNull BlockNBTComponent absoluteWorldPos(int x, int y, int z) {
        return this.worldPos(WorldPos.Coordinate.absolute(x), WorldPos.Coordinate.absolute(y), WorldPos.Coordinate.absolute(z));
    }

    default public @NonNull BlockNBTComponent relativeWorldPos(int x, int y, int z) {
        return this.worldPos(WorldPos.Coordinate.relative(x), WorldPos.Coordinate.relative(y), WorldPos.Coordinate.relative(z));
    }

    public static interface LocalPos
    extends Pos {
        public static @NonNull LocalPos of(double left, double up, double forwards) {
            return new BlockNBTComponentImpl.LocalPosImpl(left, up, forwards);
        }

        public double left();

        public double up();

        public double forwards();
    }

    public static interface Pos
    extends Examinable {
        public static @NonNull Pos fromString(@NonNull String input) throws IllegalArgumentException {
            Matcher localMatch = BlockNBTComponentImpl.Tokens.LOCAL_PATTERN.matcher(input);
            if (localMatch.matches()) {
                return LocalPos.of(Double.parseDouble(localMatch.group(1)), Double.parseDouble(localMatch.group(3)), Double.parseDouble(localMatch.group(5)));
            }
            Matcher worldMatch = BlockNBTComponentImpl.Tokens.WORLD_PATTERN.matcher(input);
            if (worldMatch.matches()) {
                return WorldPos.of(BlockNBTComponentImpl.Tokens.deserializeCoordinate(worldMatch.group(1), worldMatch.group(2)), BlockNBTComponentImpl.Tokens.deserializeCoordinate(worldMatch.group(3), worldMatch.group(4)), BlockNBTComponentImpl.Tokens.deserializeCoordinate(worldMatch.group(5), worldMatch.group(6)));
            }
            throw new IllegalArgumentException("Cannot convert position specification '" + input + "' into a position");
        }

        public @NonNull String asString();
    }

    public static interface WorldPos
    extends Pos {
        public static @NonNull WorldPos of(@NonNull Coordinate x, @NonNull Coordinate y, @NonNull Coordinate z) {
            return new BlockNBTComponentImpl.WorldPosImpl(x, y, z);
        }

        public @NonNull Coordinate x();

        public @NonNull Coordinate y();

        public @NonNull Coordinate z();

        public static interface Coordinate
        extends Examinable {
            public static @NonNull Coordinate absolute(int value) {
                return Coordinate.of(value, Type.ABSOLUTE);
            }

            public static @NonNull Coordinate relative(int value) {
                return Coordinate.of(value, Type.RELATIVE);
            }

            public static @NonNull Coordinate of(int value, @NonNull Type type) {
                return new BlockNBTComponentImpl.WorldPosImpl.CoordinateImpl(value, type);
            }

            public int value();

            public @NonNull Type type();

            public static enum Type {
                ABSOLUTE,
                RELATIVE;

            }
        }
    }

    public static interface Builder
    extends NBTComponentBuilder<BlockNBTComponent, Builder> {
        public @NonNull Builder pos(@NonNull Pos var1);

        default public @NonNull Builder localPos(double left, double up, double forwards) {
            return this.pos(LocalPos.of(left, up, forwards));
        }

        default public @NonNull Builder worldPos(@NonNull WorldPos.Coordinate x, @NonNull WorldPos.Coordinate y, @NonNull WorldPos.Coordinate z) {
            return this.pos(WorldPos.of(x, y, z));
        }

        default public @NonNull Builder absoluteWorldPos(int x, int y, int z) {
            return this.worldPos(WorldPos.Coordinate.absolute(x), WorldPos.Coordinate.absolute(y), WorldPos.Coordinate.absolute(z));
        }

        default public @NonNull Builder relativeWorldPos(int x, int y, int z) {
            return this.worldPos(WorldPos.Coordinate.relative(x), WorldPos.Coordinate.relative(y), WorldPos.Coordinate.relative(z));
        }
    }
}

