/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.lucko.spark.lib.adventure.examination.Examinable;
import me.lucko.spark.lib.adventure.inventory.BookImpl;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.util.Buildable;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Book
extends Buildable<Book, Builder>,
Examinable {
    public static @NonNull Book book(@NonNull Component title, @NonNull Component author, @NonNull Collection<Component> pages) {
        return new BookImpl(title, author, new ArrayList<Component>(pages));
    }

    public static @NonNull Book book(@NonNull Component title, @NonNull Component author, Component ... pages) {
        return Book.book(title, author, Arrays.asList(pages));
    }

    public static @NonNull Builder builder() {
        return new BookImpl.BuilderImpl();
    }

    public @NonNull Component title();

    public @NonNull Book title(@NonNull Component var1);

    public @NonNull Component author();

    public @NonNull Book author(@NonNull Component var1);

    public @NonNull List<Component> pages();

    default public @NonNull Book pages(Component ... pages) {
        return this.pages(Arrays.asList(pages));
    }

    public @NonNull Book pages(@NonNull List<Component> var1);

    @Override
    default public @NonNull Builder toBuilder() {
        return Book.builder().title(this.title()).author(this.author()).pages(this.pages());
    }

    public static interface Builder
    extends Buildable.Builder<Book> {
        public @NonNull Builder title(@NonNull Component var1);

        public @NonNull Builder author(@NonNull Component var1);

        public @NonNull Builder addPage(@NonNull Component var1);

        public @NonNull Builder pages(Component ... var1);

        public @NonNull Builder pages(@NonNull Collection<Component> var1);

        @Override
        public @NonNull Book build();
    }
}

