/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.bossbar;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import me.lucko.spark.lib.adventure.bossbar.BossBar;
import me.lucko.spark.lib.adventure.examination.ExaminableProperty;
import me.lucko.spark.lib.adventure.examination.string.StringExaminer;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.util.Listenable;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BossBarImpl
extends Listenable<BossBar.Listener>
implements BossBar {
    private static final BiConsumer<BossBarImpl, Set<BossBar.Flag>> FLAGS_ADDED = (bar, flagsAdded) -> bar.forEachListener(listener -> listener.bossBarFlagsChanged((BossBar)bar, (Set<BossBar.Flag>)flagsAdded, Collections.emptySet()));
    private static final BiConsumer<BossBarImpl, Set<BossBar.Flag>> FLAGS_REMOVED = (bar, flagsRemoved) -> bar.forEachListener(listener -> listener.bossBarFlagsChanged((BossBar)bar, Collections.emptySet(), (Set<BossBar.Flag>)flagsRemoved));
    private Component name;
    private float percent;
    private BossBar.Color color;
    private BossBar.Overlay overlay;
    private final Set<BossBar.Flag> flags = EnumSet.noneOf(BossBar.Flag.class);

    BossBarImpl(@NonNull Component name, float percent, @NonNull BossBar.Color color, @NonNull BossBar.Overlay overlay) {
        this.name = Objects.requireNonNull(name, "name");
        this.percent = percent;
        this.color = Objects.requireNonNull(color, "color");
        this.overlay = Objects.requireNonNull(overlay, "overlay");
    }

    BossBarImpl(@NonNull Component name, float percent, @NonNull BossBar.Color color, @NonNull BossBar.Overlay overlay, @NonNull Set<BossBar.Flag> flags) {
        this(name, percent, color, overlay);
        this.flags.addAll(flags);
    }

    @Override
    public @NonNull Component name() {
        return this.name;
    }

    @Override
    public @NonNull BossBar name(@NonNull Component newName) {
        Objects.requireNonNull(newName, "name");
        Component oldName = this.name;
        if (!Objects.equals(newName, oldName)) {
            this.name = newName;
            this.forEachListener(listener -> listener.bossBarNameChanged(this, oldName, newName));
        }
        return this;
    }

    @Override
    public float percent() {
        return this.percent;
    }

    @Override
    public @NonNull BossBar percent(float newPercent) {
        BossBarImpl.checkPercent(newPercent);
        float oldPercent = this.percent;
        if (newPercent != oldPercent) {
            this.percent = newPercent;
            this.forEachListener(listener -> listener.bossBarPercentChanged(this, oldPercent, newPercent));
        }
        return this;
    }

    static void checkPercent(float percent) {
        if (percent < 0.0f || percent > 1.0f) {
            throw new IllegalArgumentException("percent must be between 0.0 and 1.0, was " + percent);
        }
    }

    @Override
    public @NonNull BossBar.Color color() {
        return this.color;
    }

    @Override
    public @NonNull BossBar color(@NonNull BossBar.Color newColor) {
        Objects.requireNonNull(newColor, "color");
        BossBar.Color oldColor = this.color;
        if (newColor != oldColor) {
            this.color = newColor;
            this.forEachListener(listener -> listener.bossBarColorChanged(this, oldColor, newColor));
        }
        return this;
    }

    @Override
    public @NonNull BossBar.Overlay overlay() {
        return this.overlay;
    }

    @Override
    public @NonNull BossBar overlay(@NonNull BossBar.Overlay newOverlay) {
        Objects.requireNonNull(newOverlay, "overlay");
        BossBar.Overlay oldOverlay = this.overlay;
        if (newOverlay != oldOverlay) {
            this.overlay = newOverlay;
            this.forEachListener(listener -> listener.bossBarOverlayChanged(this, oldOverlay, newOverlay));
        }
        return this;
    }

    @Override
    public @NonNull Set<BossBar.Flag> flags() {
        return this.flags;
    }

    @Override
    public @NonNull BossBar flags(@NonNull Set<BossBar.Flag> newFlags) {
        if (newFlags.isEmpty()) {
            EnumSet<BossBar.Flag> oldFlags = EnumSet.copyOf(this.flags);
            this.flags.clear();
            this.forEachListener(listener -> listener.bossBarFlagsChanged(this, Collections.emptySet(), oldFlags));
        } else if (!this.flags.equals(newFlags)) {
            EnumSet<BossBar.Flag> oldFlags = EnumSet.copyOf(this.flags);
            this.flags.clear();
            this.flags.addAll(newFlags);
            EnumSet<BossBar.Flag> added = EnumSet.copyOf(newFlags);
            added.removeIf(oldFlags::contains);
            EnumSet<BossBar.Flag> removed = EnumSet.copyOf(oldFlags);
            removed.removeIf(this.flags::contains);
            this.forEachListener(listener -> listener.bossBarFlagsChanged(this, added, removed));
        }
        return this;
    }

    @Override
    public boolean hasFlag(@NonNull BossBar.Flag flag) {
        return this.flags.contains((Object)flag);
    }

    @Override
    public @NonNull BossBar addFlag(@NonNull BossBar.Flag flag) {
        return this.editFlags(flag, Set::add, FLAGS_ADDED);
    }

    @Override
    public @NonNull BossBar removeFlag(@NonNull BossBar.Flag flag) {
        return this.editFlags(flag, Set::remove, FLAGS_REMOVED);
    }

    private @NonNull BossBar editFlags(@NonNull BossBar.Flag flag, @NonNull BiPredicate<Set<BossBar.Flag>, BossBar.Flag> predicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> onChange) {
        if (predicate.test(this.flags, flag)) {
            onChange.accept(this, Collections.singleton(flag));
        }
        return this;
    }

    @Override
    public @NonNull BossBar addFlags(BossBar.Flag ... flags) {
        return this.editFlags(flags, Set::add, FLAGS_ADDED);
    }

    @Override
    public @NonNull BossBar removeFlags(BossBar.Flag ... flags) {
        return this.editFlags(flags, Set::remove, FLAGS_REMOVED);
    }

    private @NonNull BossBar editFlags(BossBar.Flag[] flags, BiPredicate<Set<BossBar.Flag>, BossBar.Flag> predicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> onChange) {
        if (flags.length == 0) {
            return this;
        }
        EnumSet<BossBar.Flag> changes = null;
        int length = flags.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(this.flags, flags[i])) continue;
            if (changes == null) {
                changes = EnumSet.noneOf(BossBar.Flag.class);
            }
            changes.add(flags[i]);
        }
        if (changes != null) {
            onChange.accept(this, changes);
        }
        return this;
    }

    @Override
    public @NonNull BossBar addFlags(@NonNull Iterable<BossBar.Flag> flags) {
        return this.editFlags(flags, Set::add, FLAGS_ADDED);
    }

    @Override
    public @NonNull BossBar removeFlags(@NonNull Iterable<BossBar.Flag> flags) {
        return this.editFlags(flags, Set::remove, FLAGS_REMOVED);
    }

    private @NonNull BossBar editFlags(Iterable<BossBar.Flag> flags, BiPredicate<Set<BossBar.Flag>, BossBar.Flag> predicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> onChange) {
        EnumSet<BossBar.Flag> changes = null;
        for (BossBar.Flag flag : flags) {
            if (!predicate.test(this.flags, flag)) continue;
            if (changes == null) {
                changes = EnumSet.noneOf(BossBar.Flag.class);
            }
            changes.add(flag);
        }
        if (changes != null) {
            onChange.accept(this, changes);
        }
        return this;
    }

    @Override
    public @NonNull BossBar addListener(@NonNull BossBar.Listener listener) {
        this.addListener0(listener);
        return this;
    }

    @Override
    public @NonNull BossBar removeListener(@NonNull BossBar.Listener listener) {
        this.removeListener0(listener);
        return this;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("name", this.name), ExaminableProperty.of("percent", this.percent), ExaminableProperty.of("color", (Object)this.color), ExaminableProperty.of("overlay", (Object)this.overlay), ExaminableProperty.of("flags", this.flags));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }
}

