/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.SparkPlugin;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.forge.ForgeCommandSender;
import me.lucko.spark.forge.ForgeSparkMod;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public abstract class ForgeSparkPlugin
implements SparkPlugin,
ICommand {
    private final ForgeSparkMod mod;
    protected final ScheduledExecutorService scheduler;
    protected final SparkPlatform platform;

    protected ForgeSparkPlugin(ForgeSparkMod mod) {
        this.mod = mod;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("spark-forge-async-worker");
            thread.setDaemon(true);
            return thread;
        });
        this.platform = new SparkPlatform(this);
        this.platform.enable();
    }

    public void enable() {
        this.platform.enable();
    }

    public void disable() {
        this.platform.disable();
        this.scheduler.shutdown();
    }

    public abstract boolean hasPermission(ICommandSender var1, String var2);

    @Override
    public String getVersion() {
        return this.mod.getVersion();
    }

    @Override
    public Path getPluginDirectory() {
        return this.mod.getConfigDirectory();
    }

    @Override
    public void executeAsync(Runnable task) {
        this.scheduler.execute(task);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return new ThreadDumper.Specific(new long[]{Thread.currentThread().getId()});
    }

    public String func_71517_b() {
        return this.getCommandName();
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "/" + this.getCommandName();
    }

    public List<String> func_71514_a() {
        return Collections.singletonList(this.getCommandName());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        this.platform.executeCommand(new ForgeCommandSender(sender, this), args);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos blockPos) {
        return this.platform.tabCompleteCommand(new ForgeCommandSender(sender, this), args);
    }

    public boolean func_184882_a(MinecraftServer minecraftServer, ICommandSender sender) {
        return this.hasPermission(sender, "spark");
    }

    public boolean func_82358_a(String[] strings, int i) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.getCommandName().compareTo(o.func_71517_b());
    }
}

