/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

public enum FormatUtil {

    private static final String[] SIZE_UNITS = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};

    public static String percent(double value, double max) {
        double percent = value * 100.0 / max;
        return (int)percent + "%";
    }

    public static String formatBytes(long bytes) {
        if (bytes == 0L) {
            return "0 bytes";
        }
        int sizeIndex = (int)(Math.log(bytes) / Math.log(1024.0));
        return String.format("%.1f", (double)bytes / Math.pow(1024.0, sizeIndex)) + " " + SIZE_UNITS[sizeIndex];
    }
}

