/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.node;

import java.util.Objects;
import me.lucko.spark.common.sampler.node.AbstractNode;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.util.MethodDisambiguator;
import me.lucko.spark.proto.SparkProtos;

public final class StackTraceNode
extends AbstractNode
implements Comparable<StackTraceNode> {
    public static final int NULL_LINE_NUMBER = -1;
    private final Description description;

    public StackTraceNode(Description description) {
        this.description = description;
    }

    public String getClassName() {
        return this.description.className;
    }

    public String getMethodName() {
        return this.description.methodName;
    }

    public int getLineNumber() {
        return this.description.lineNumber;
    }

    public int getParentLineNumber() {
        return this.description.parentLineNumber;
    }

    public SparkProtos.StackTraceNode toProto(MergeMode mergeMode) {
        SparkProtos.StackTraceNode.Builder proto = SparkProtos.StackTraceNode.newBuilder().setTime(this.getTotalTime()).setClassName(this.description.className).setMethodName(this.description.methodName);
        if (this.description.lineNumber >= 0) {
            proto.setLineNumber(this.description.lineNumber);
        }
        if (mergeMode.separateParentCalls() && this.description.parentLineNumber >= 0) {
            proto.setParentLineNumber(this.description.parentLineNumber);
        }
        mergeMode.getMethodDisambiguator().disambiguate(this).map(MethodDisambiguator.MethodDescription::getDesc).ifPresent(proto::setMethodDesc);
        for (StackTraceNode child : this.exportChildren(mergeMode)) {
            proto.addChildren(child.toProto(mergeMode));
        }
        return proto.build();
    }

    @Override
    public int compareTo(StackTraceNode that) {
        if (this == that) {
            return 0;
        }
        int i = -Double.compare(this.getTotalTime(), that.getTotalTime());
        if (i != 0) {
            return i;
        }
        return this.description.compareTo(that.description);
    }

    public static final class Description
    implements Comparable<Description> {
        private final String className;
        private final String methodName;
        private final int lineNumber;
        private final int parentLineNumber;
        private final int hash;

        public Description(String className, String methodName, int lineNumber, int parentLineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
            this.parentLineNumber = parentLineNumber;
            this.hash = Objects.hash(this.className, this.methodName, this.lineNumber, this.parentLineNumber);
        }

        @Override
        public int compareTo(Description that) {
            if (this == that) {
                return 0;
            }
            int i = this.className.compareTo(that.className);
            if (i != 0) {
                return i;
            }
            i = this.methodName.compareTo(that.methodName);
            if (i != 0) {
                return i;
            }
            i = Integer.compare(this.lineNumber, that.lineNumber);
            if (i != 0) {
                return i;
            }
            return Integer.compare(this.parentLineNumber, that.parentLineNumber);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Description description = (Description)o;
            return this.lineNumber == description.lineNumber && this.parentLineNumber == description.parentLineNumber && this.className.equals(description.className) && this.methodName.equals(description.methodName);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

