/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.aggregator;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.aggregator.AbstractDataAggregator;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.proto.SparkProtos;

public class TickedDataAggregator
extends AbstractDataAggregator {
    private final TickHook tickHook;
    private final long tickLengthThreshold;
    private final int expectedSize;
    private final Object mutex = new Object();
    private int currentTick = -1;
    private TickList currentData = new TickList(0);

    public TickedDataAggregator(ExecutorService workerPool, ThreadGrouper threadGrouper, int interval, boolean ignoreSleeping, boolean ignoreNative, TickHook tickHook, int tickLengthThreshold) {
        super(workerPool, threadGrouper, interval, ignoreSleeping, ignoreNative);
        this.tickHook = tickHook;
        this.tickLengthThreshold = TimeUnit.MILLISECONDS.toMicros(tickLengthThreshold);
        double intervalMilliseconds = (double)interval / 1000.0;
        this.expectedSize = (int)(50.0 / intervalMilliseconds + 10.0);
    }

    @Override
    public SparkProtos.SamplerMetadata.DataAggregator getMetadata() {
        return SparkProtos.SamplerMetadata.DataAggregator.newBuilder().setType(SparkProtos.SamplerMetadata.DataAggregator.Type.TICKED).setThreadGrouper(this.threadGrouper.asProto()).setTickLengthThreshold(this.tickLengthThreshold).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertData(ThreadInfo threadInfo) {
        Object object = this.mutex;
        synchronized (object) {
            int tick = this.tickHook.getCurrentTick();
            if (this.currentTick != tick) {
                this.pushCurrentTick();
                this.currentTick = tick;
                this.currentData = new TickList(this.expectedSize);
            }
            this.currentData.addData(threadInfo);
        }
    }

    private void pushCurrentTick() {
        TickList currentData = this.currentData;
        int tickLengthMicros = currentData.getList().size() * this.interval;
        if ((long)tickLengthMicros < this.tickLengthThreshold) {
            return;
        }
        this.workerPool.submit(currentData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ThreadNode> getData() {
        Object object = this.mutex;
        synchronized (object) {
            this.pushCurrentTick();
        }
        this.workerPool.shutdown();
        try {
            this.workerPool.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.threadData;
    }

    private final class TickList
    implements Runnable {
        private final List<ThreadInfo> list;

        TickList(int expectedSize) {
            this.list = new ArrayList<ThreadInfo>(expectedSize);
        }

        @Override
        public void run() {
            for (ThreadInfo data : this.list) {
                TickedDataAggregator.this.writeData(data);
            }
        }

        public List<ThreadInfo> getList() {
            return this.list;
        }

        public void addData(ThreadInfo data) {
            this.list.add(data);
        }
    }
}

