/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.aggregator;

import java.lang.management.ThreadInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.aggregator.DataAggregator;
import me.lucko.spark.common.sampler.node.ThreadNode;

public abstract class AbstractDataAggregator
implements DataAggregator {
    protected final Map<String, ThreadNode> threadData = new ConcurrentHashMap<String, ThreadNode>();
    protected final ExecutorService workerPool;
    protected final ThreadGrouper threadGrouper;
    protected final int interval;
    private final boolean ignoreSleeping;
    private final boolean ignoreNative;

    public AbstractDataAggregator(ExecutorService workerPool, ThreadGrouper threadGrouper, int interval, boolean ignoreSleeping, boolean ignoreNative) {
        this.workerPool = workerPool;
        this.threadGrouper = threadGrouper;
        this.interval = interval;
        this.ignoreSleeping = ignoreSleeping;
        this.ignoreNative = ignoreNative;
    }

    protected ThreadNode getNode(String group) {
        ThreadNode node = this.threadData.get(group);
        if (node != null) {
            return node;
        }
        return this.threadData.computeIfAbsent(group, ThreadNode::new);
    }

    protected void writeData(ThreadInfo threadInfo) {
        if (this.ignoreSleeping && AbstractDataAggregator.isSleeping(threadInfo)) {
            return;
        }
        if (this.ignoreNative && threadInfo.isInNative()) {
            return;
        }
        try {
            ThreadNode node = this.getNode(this.threadGrouper.getGroup(threadInfo.getThreadId(), threadInfo.getThreadName()));
            node.log(threadInfo.getStackTrace(), this.interval);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isSleeping(ThreadInfo thread) {
        if (thread.getThreadState() == Thread.State.WAITING || thread.getThreadState() == Thread.State.TIMED_WAITING) {
            return true;
        }
        StackTraceElement[] stackTrace = thread.getStackTrace();
        if (stackTrace.length == 0) {
            return false;
        }
        StackTraceElement call = stackTrace[0];
        String clazz = call.getClassName();
        String method = call.getMethodName();
        return clazz.equals("java.lang.Thread") && method.equals("yield") || clazz.equals("jdk.internal.misc.Unsafe") && method.equals("park") || clazz.equals("sun.misc.Unsafe") && method.equals("park");
    }
}

