/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.monitor.tick;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.text.DecimalFormat;
import java.util.DoubleSummaryStatistics;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.monitor.memory.GarbageCollectionMonitor;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;

public abstract class TickMonitor
implements TickHook.Callback,
GarbageCollectionMonitor.Listener,
AutoCloseable {
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private final SparkPlatform platform;
    private final TickHook tickHook;
    private final int zeroTick;
    private final GarbageCollectionMonitor garbageCollectionMonitor;
    private final ReportPredicate reportPredicate;
    private volatile double lastTickTime = 0.0;
    private State state = null;
    private final DoubleSummaryStatistics averageTickTime = new DoubleSummaryStatistics();
    private double avg;

    public TickMonitor(SparkPlatform platform, TickHook tickHook, ReportPredicate reportPredicate, boolean monitorGc) {
        this.platform = platform;
        this.tickHook = tickHook;
        this.zeroTick = tickHook.getCurrentTick();
        this.reportPredicate = reportPredicate;
        if (monitorGc) {
            this.garbageCollectionMonitor = new GarbageCollectionMonitor();
            this.garbageCollectionMonitor.addListener(this);
        } else {
            this.garbageCollectionMonitor = null;
        }
    }

    public int getCurrentTick() {
        return this.tickHook.getCurrentTick() - this.zeroTick;
    }

    protected abstract void sendMessage(Component var1);

    @Override
    public void close() {
        if (this.garbageCollectionMonitor != null) {
            this.garbageCollectionMonitor.close();
        }
    }

    @Override
    public void onTick(int currentTick) {
        double percentageChange;
        double increase;
        double now = (double)System.nanoTime() / 1000000.0;
        if (this.state == null) {
            this.state = State.SETUP;
            this.lastTickTime = now;
            this.sendMessage(Component.text("Tick monitor started. Before the monitor becomes fully active, the server's average tick rate will be calculated over a period of 120 ticks (approx 6 seconds)."));
            return;
        }
        double last = this.lastTickTime;
        double tickDuration = now - last;
        this.lastTickTime = now;
        if (last == 0.0) {
            return;
        }
        if (this.state == State.SETUP) {
            this.averageTickTime.accept(tickDuration);
            if (this.averageTickTime.getCount() >= 120L) {
                this.platform.getPlugin().executeAsync(() -> {
                    this.sendMessage(Component.text("Analysis is now complete.", (TextColor)NamedTextColor.GOLD));
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text(">", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("Max: "))).append((Component)Component.text(df.format(this.averageTickTime.getMax())))).append((Component)Component.text("ms"))).build());
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text(">", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("Min: "))).append((Component)Component.text(df.format(this.averageTickTime.getMin())))).append((Component)Component.text("ms"))).build());
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text(">", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("Average: "))).append((Component)Component.text(df.format(this.averageTickTime.getAverage())))).append((Component)Component.text("ms"))).build());
                    this.sendMessage(this.reportPredicate.monitoringStartMessage());
                });
                this.avg = this.averageTickTime.getAverage();
                this.state = State.MONITORING;
            }
        }
        if (this.state == State.MONITORING && this.reportPredicate.shouldReport(tickDuration, increase = tickDuration - this.avg, percentageChange = increase * 100.0 / this.avg)) {
            this.platform.getPlugin().executeAsync(() -> this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text("Tick "))).append((Component)Component.text("#" + this.getCurrentTick(), (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(" lasted "))).append((Component)Component.text(df.format(tickDuration), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" ms. "))).append((Component)Component.text("("))).append((Component)Component.text(df.format(percentageChange) + "%", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" increase from avg)"))).build()));
        }
    }

    @Override
    public void onGc(GarbageCollectionNotificationInfo data) {
        if (this.state == State.SETUP) {
            this.lastTickTime = 0.0;
            return;
        }
        String gcType = data.getGcAction().equals("end of minor GC") ? "Young Gen" : (data.getGcAction().equals("end of major GC") ? "Old Gen" : data.getGcAction());
        this.platform.getPlugin().executeAsync(() -> this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text("Tick "))).append((Component)Component.text("#" + this.getCurrentTick(), (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(" included "))).append((Component)Component.text("GC", (TextColor)NamedTextColor.RED))).append((Component)Component.text(" lasting "))).append((Component)Component.text(df.format(data.getGcInfo().getDuration()), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" ms. (type = " + gcType + ")"))).build()));
    }

    private static enum State {
        SETUP,
        MONITORING;

    }

    public static interface ReportPredicate {
        public boolean shouldReport(double var1, double var3, double var5);

        public Component monitoringStartMessage();

        public static final class DurationGt
        implements ReportPredicate {
            private final double threshold;

            public DurationGt(double threshold) {
                this.threshold = threshold;
            }

            @Override
            public boolean shouldReport(double duration, double increaseFromAvg, double percentageChange) {
                if (increaseFromAvg <= 0.0) {
                    return false;
                }
                return duration > this.threshold;
            }

            @Override
            public Component monitoringStartMessage() {
                return Component.text("Starting now, any ticks with duration >" + this.threshold + " will be reported.");
            }
        }

        public static final class PercentageChangeGt
        implements ReportPredicate {
            private final double threshold;

            public PercentageChangeGt(double threshold) {
                this.threshold = threshold;
            }

            @Override
            public boolean shouldReport(double duration, double increaseFromAvg, double percentageChange) {
                if (increaseFromAvg <= 0.0) {
                    return false;
                }
                return percentageChange > this.threshold;
            }

            @Override
            public Component monitoringStartMessage() {
                return Component.text("Starting now, any ticks with >" + this.threshold + "% increase in duration compared to the average will be reported.");
            }
        }
    }
}

