/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.monitor.memory;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class GarbageCollectionMonitor
implements NotificationListener,
AutoCloseable {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<NotificationEmitter> emitters = new ArrayList<NotificationEmitter>();

    public GarbageCollectionMonitor() {
        List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean bean : beans) {
            if (!(bean instanceof NotificationEmitter)) continue;
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)bean);
            notificationEmitter.addNotificationListener(this, null, null);
            this.emitters.add(notificationEmitter);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (!notification.getType().equals("com.sun.management.gc.notification")) {
            return;
        }
        GarbageCollectionNotificationInfo data = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
        for (Listener listener : this.listeners) {
            listener.onGc(data);
        }
    }

    @Override
    public void close() {
        for (NotificationEmitter e : this.emitters) {
            try {
                e.removeNotificationListener(this);
            }
            catch (ListenerNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        this.emitters.clear();
        this.listeners.clear();
    }

    public static interface Listener {
        public void onGc(GarbageCollectionNotificationInfo var1);
    }
}

