/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.tabcomplete;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface CompletionSupplier {
    public static final CompletionSupplier EMPTY = partial -> Collections.emptyList();

    public static CompletionSupplier startsWith(Collection<String> strings) {
        if (strings.isEmpty()) {
            return EMPTY;
        }
        return partial -> strings.stream().filter(CompletionSupplier.startsWithIgnoreCasePredicate(partial)).collect(Collectors.toList());
    }

    public static Predicate<String> startsWithIgnoreCasePredicate(String prefix) {
        return string -> {
            if (string.length() < prefix.length()) {
                return false;
            }
            return string.regionMatches(true, 0, prefix, 0, prefix.length());
        };
    }

    public List<String> supplyCompletions(String var1);
}

