/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.lib.adventure.text.format.TextDecoration;

public class CommandResponseHandler {
    private static final TextComponent PREFIX = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text("[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text("\u26a1", (TextColor)NamedTextColor.YELLOW, TextDecoration.BOLD))).append((Component)Component.text("]", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(" "))).build();
    private final SparkPlatform platform;
    private final CommandSender sender;

    public CommandResponseHandler(SparkPlatform platform, CommandSender sender) {
        this.platform = platform;
        this.sender = sender;
    }

    public CommandSender sender() {
        return this.sender;
    }

    public void allSenders(Consumer<? super CommandSender> action) {
        Set<? super CommandSender> senders = this.platform.getPlugin().getSendersWithPermission("spark").collect(Collectors.toSet());
        senders.add(this.sender);
        senders.forEach(action);
    }

    public void reply(Component message) {
        this.sender.sendMessage(message);
    }

    public void broadcast(Component message) {
        this.allSenders(sender -> sender.sendMessage(message));
    }

    public void replyPrefixed(Component message) {
        this.reply(CommandResponseHandler.applyPrefix(message));
    }

    public void broadcastPrefixed(Component message) {
        this.broadcast(CommandResponseHandler.applyPrefix(message));
    }

    public static Component applyPrefix(Component message) {
        return PREFIX.append(message);
    }
}

