/*
 * Decompiled with CFR 0.152.
 */
package dev.jjw123.ocblockreplacer.tileentity;

import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.TileEntityEnvironment;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class Replacer
extends TileEntityEnvironment
implements ISidedInventory {
    private static final String TAG_NODE = "replacer";
    private NonNullList<ItemStack> replacerItemStacks = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);

    public Replacer() {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(TAG_NODE, Visibility.Network).withConnector().create();
    }

    @Callback(doc="function(posX, posZ, negX, negZ, y, block):number --  Replaces block of name 'block' with the block stored in the internal inventory. Returns the number of blocks replaced.")
    public Object[] replace(Context context, Arguments args) throws Exception {
        int posX = args.checkInteger(0);
        int posZ = args.checkInteger(1);
        int negX = args.checkInteger(2);
        int negZ = args.checkInteger(3);
        int y = args.checkInteger(4);
        String block = args.checkString(5);
        int replaced = 0;
        for (int x = this.func_174877_v().func_177958_n() - negX; x <= this.func_174877_v().func_177958_n() + posX; ++x) {
            for (int z = this.func_174877_v().func_177952_p() - negZ; z <= this.func_174877_v().func_177952_p() + posZ; ++z) {
                BlockPos pos = new BlockPos(x, this.func_174877_v().func_177956_o() + y, z);
                IBlockState bs = this.field_145850_b.func_180495_p(pos);
                Block b = bs.func_177230_c();
                if (!b.getRegistryName().toString().equals(block)) continue;
                NonNullList drops = NonNullList.func_191196_a();
                b.getDrops(drops, (IBlockAccess)this.field_145850_b, pos, bs, 0);
                for (ItemStack drop : drops) {
                    for (int i = 1; i < this.replacerItemStacks.size(); ++i) {
                        ItemStack stack = (ItemStack)this.replacerItemStacks.get(i);
                        if (!stack.func_190926_b() && !stack.func_77973_b().getRegistryName().toString().equals(drop.func_77973_b().getRegistryName().toString())) continue;
                        ItemStack s = drop.func_77946_l();
                        int count = stack.func_190916_E() + drop.func_190916_E();
                        if (count > this.func_70297_j_()) {
                            s.func_190920_e(this.func_70297_j_());
                            drop.func_190920_e(count - this.func_70297_j_());
                            this.replacerItemStacks.set(i, (Object)s);
                            continue;
                        }
                        s.func_190920_e(count);
                        drop.func_190920_e(0);
                        this.replacerItemStacks.set(i, (Object)s);
                        break;
                    }
                    if (drop.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 1.0f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), (ItemStack)drop);
                }
                ItemStack place = this.func_70298_a(0, 1);
                if (place.func_190926_b() || !(place.func_77973_b() instanceof ItemBlock) || !(this.field_145850_b instanceof WorldServer)) continue;
                ItemBlock ib = (ItemBlock)place.func_77973_b();
                IBlockState placeState = ib.func_179223_d().getStateForPlacement(this.field_145850_b, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, place.func_77960_j(), (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b)), EnumHand.MAIN_HAND);
                this.field_145850_b.func_175656_a(pos, placeState);
                ++replaced;
            }
        }
        this.func_70296_d();
        return new Object[]{replaced};
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (index > 0) {
            return false;
        }
        return itemStackIn.func_77973_b() instanceof ItemBlock;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.replacerItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.replacerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.replacerItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.replacerItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.replacerItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.replacerItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index > 0) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemBlock;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return TAG_NODE;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.replacerItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.replacerItemStacks);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.replacerItemStacks);
        return compound;
    }

    public void func_70296_d() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

