/*
 * Decompiled with CFR 0.152.
 */
package dev.jjw123.ocblockreplacer;

import dev.jjw123.ocblockreplacer.block.BlockReplacer;
import dev.jjw123.ocblockreplacer.client.renderer.ReplacerTESR;
import dev.jjw123.ocblockreplacer.tileentity.Replacer;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="ocblockreplacer", name="OC Block Replacer", version="1.0.2", dependencies="required-after:opencomputers")
public class OCBlockReplacer {
    public static final String MOD_ID = "ocblockreplacer";
    public static final String MOD_NAME = "OC Block Replacer";
    @Mod.Instance(value="ocblockreplacer")
    public static OCBlockReplacer INSTANCE;
    static HashSet<Block> modBlocks;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        modBlocks.add((Block)new BlockReplacer());
    }

    static {
        modBlocks = new HashSet();
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class ClientEventSubscriber {
        @SubscribeEvent
        public static void onModelRegistryEvent(@Nonnull ModelRegistryEvent event) {
            ClientRegistry.bindTileEntitySpecialRenderer(Replacer.class, (TileEntitySpecialRenderer)new ReplacerTESR());
            for (Block block : modBlocks) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class ObjectRegistryHandler {
        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            for (Block block : modBlocks) {
                event.getRegistry().register((IForgeRegistryEntry)((Item)new ItemBlock(block).setRegistryName(OCBlockReplacer.MOD_ID, "replacer")).func_77655_b("replacer"));
            }
        }

        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> event) {
            for (Block block : modBlocks) {
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
            GameRegistry.registerTileEntity(Replacer.class, (ResourceLocation)new ResourceLocation(OCBlockReplacer.MOD_ID, "replacer"));
        }
    }
}

