/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.api.straw.StrawHandler;
import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.utils.StrawUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStraw
extends IFCustomItem {
    public ItemStraw() {
        super("straw");
        this.func_77625_d(1);
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack heldStack, World world, EntityLivingBase entity) {
        EntityPlayer player;
        RayTraceResult result;
        if (!world.field_72995_K && entity instanceof EntityPlayer && (result = this.func_77621_a(world, player = (EntityPlayer)entity, true)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile;
            BlockPos pos = result.func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
            if (fluid != null) {
                FluidStack stack = new FluidStack(fluid, 1000);
                StrawUtils.getStrawHandler(stack).ifPresent(handler -> handler.onDrink(world, pos, stack, player, false));
                world.func_175698_g(pos);
                return heldStack;
            }
            if (block.hasTileEntity(state) && (tile = world.func_175625_s(pos)) != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IFluidTankProperties[] fluidTankProperties;
                IFluidHandler handler2 = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                for (IFluidTankProperties properties : fluidTankProperties = handler2.getTankProperties()) {
                    FluidStack stack = properties.getContents();
                    if (stack == null || (fluid = stack.getFluid()) == null || stack.amount < 1000) continue;
                    FluidStack copiedStack = stack.copy();
                    copiedStack.amount = 1000;
                    FluidStack out = handler2.drain(copiedStack, false);
                    if (out == null || out.amount != 1000) continue;
                    StrawUtils.getStrawHandler(stack).ifPresent(strawHandler -> strawHandler.onDrink(world, pos, stack, player, true));
                    handler2.drain(copiedStack, true);
                    return heldStack;
                }
            }
        }
        return super.func_77654_b(heldStack, world, entity);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        RayTraceResult result = this.func_77621_a(worldIn, playerIn, true);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile;
            BlockPos pos = result.func_178782_a();
            IBlockState state = worldIn.func_180495_p(pos);
            Block block = state.func_177230_c();
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
            if (fluid != null) {
                Optional<StrawHandler> handler = StrawUtils.getStrawHandler(new FluidStack(fluid, 1000));
                if (handler.isPresent()) {
                    playerIn.func_184598_c(handIn);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
            }
            if (block.hasTileEntity(state) && (tile = worldIn.func_175625_s(pos)) != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IFluidTankProperties[] fluidTankProperties;
                IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                for (IFluidTankProperties properties : fluidTankProperties = handler.getTankProperties()) {
                    FluidStack out;
                    FluidStack stack = properties.getContents();
                    if (stack == null) continue;
                    fluid = stack.getFluid();
                    Optional<StrawHandler> strawHandler = StrawUtils.getStrawHandler(stack);
                    if (fluid == null || !strawHandler.isPresent() || stack.amount < 1000 || (out = handler.drain(stack, false)) == null || out.amount < 1000) continue;
                    playerIn.func_184598_c(handIn);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public int func_77626_a(ItemStack stack) {
        return 30;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add("\"The One Who Codes\"");
    }
}

