/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.extractor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ExtractorEntry {
    public static List<ExtractorEntry> EXTRACTOR_ENTRIES = new ArrayList<ExtractorEntry>();
    private final ItemStack itemStack;
    private final FluidStack fluidStack;
    private final float breakChance;

    public ExtractorEntry(ItemStack itemStack, FluidStack fluidStack) {
        this(itemStack, fluidStack, 0.005f);
    }

    public ExtractorEntry(ItemStack itemStack, FluidStack fluidStack, float breakChance) {
        this.itemStack = itemStack;
        this.fluidStack = fluidStack;
        this.breakChance = breakChance;
    }

    public static ExtractorEntry getExtractorEntry(World world, BlockPos pos) {
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)world.func_180495_p(pos).func_177230_c()), 1, world.func_180495_p(pos).func_177230_c().func_180651_a(world.func_180495_p(pos)));
        if (!stack.func_190926_b()) {
            for (ExtractorEntry extractorEntry : EXTRACTOR_ENTRIES) {
                if (!extractorEntry.isEqual(stack)) continue;
                return extractorEntry;
            }
        }
        return null;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public boolean isEqual(ItemStack stack) {
        return stack.func_77969_a(this.getItemStack());
    }

    public float getBreakChance() {
        return this.breakChance;
    }
}

