/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network.response;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.dries007.holoInventory.client.renderers.InventoryRenderer;
import net.dries007.holoInventory.network.response.ResponseMessage;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class PlainInventory
extends ResponseMessage {
    private String name;
    private List<ItemStack> stacks;

    public PlainInventory() {
    }

    public PlainInventory(int id, IInventory ii) {
        super(id);
        this.scan(ii);
    }

    public PlainInventory(BlockPos pos, IInventory ii) {
        super(pos);
        this.scan(ii);
    }

    public PlainInventory(int id, String name, IItemHandler ii) {
        super(id);
        this.scan(ii);
        this.name = name;
    }

    public PlainInventory(BlockPos pos, String name, IItemHandler ii) {
        super(pos);
        this.scan(ii);
        this.name = name;
    }

    private void add(ItemStack s) {
        if (s.func_190926_b()) {
            return;
        }
        this.stacks.add(s);
    }

    private void scan(IItemHandler ii) {
        int size = ii.getSlots();
        this.stacks = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            this.add(ii.getStackInSlot(i));
        }
    }

    private void scan(IInventory ii) {
        this.name = ii.func_70005_c_();
        int size = ii.func_70302_i_();
        this.stacks = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            this.add(ii.func_70301_a(i));
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int size = buf.readInt();
        this.stacks = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            this.add(ByteBufUtils.readItemStack((ByteBuf)buf));
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)Strings.nullToEmpty((String)this.name));
        buf.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    public PlainInventory setName(String name) {
        this.name = name;
        return this;
    }

    public static class Handler
    implements IMessageHandler<PlainInventory, IMessage> {
        public IMessage onMessage(PlainInventory message, MessageContext ctx) {
            ResponseMessage.handle(message, new InventoryRenderer(message.name, message.stacks));
            return null;
        }
    }
}

