/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network.response;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import net.dries007.holoInventory.client.renderers.MerchantRenderer;
import net.dries007.holoInventory.network.response.ResponseMessage;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MerchantRecipes
extends ResponseMessage {
    private String name;
    private NBTTagCompound tag;

    public MerchantRecipes() {
    }

    public MerchantRecipes(int id, IMerchant entity, EntityPlayerMP player) {
        super(id);
        this.name = entity.func_145748_c_().func_150254_d();
        MerchantRecipeList recipes = entity.func_70934_b((EntityPlayer)player);
        if (recipes == null) {
            recipes = new MerchantRecipeList();
        }
        this.tag = recipes.func_77202_a();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)Strings.nullToEmpty((String)this.name));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public static class Handler
    implements IMessageHandler<MerchantRecipes, IMessage> {
        public IMessage onMessage(MerchantRecipes message, MessageContext ctx) {
            ResponseMessage.handle(message, new MerchantRenderer(message.name, new MerchantRecipeList(message.tag)));
            return null;
        }
    }
}

