/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network.request;

import io.netty.buffer.ByteBuf;
import net.dries007.holoInventory.Helper;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.api.INamedItemHandler;
import net.dries007.holoInventory.network.request.RequestMessage;
import net.dries007.holoInventory.network.response.PlainInventory;
import net.dries007.holoInventory.network.response.ResponseMessage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockJukebox;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileRequest
extends RequestMessage {
    private BlockPos pos;

    public TileRequest() {
    }

    public TileRequest(int dimension, BlockPos blockPos) {
        super(dimension);
        this.pos = blockPos;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public static class Handler
    implements IMessageHandler<TileRequest, ResponseMessage> {
        public ResponseMessage onMessage(TileRequest message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world == null) {
                return null;
            }
            TileEntity te = world.func_175625_s(message.pos);
            if (te == null) {
                return null;
            }
            if (Helper.banned.contains(te.getClass().getCanonicalName())) {
                return null;
            }
            if (te instanceof ILockableContainer && !ctx.getServerHandler().field_147369_b.func_175146_a(((ILockableContainer)te).func_174891_i())) {
                return null;
            }
            if (te instanceof TileEntityEnderChest) {
                return new PlainInventory(message.pos, (IInventory)ctx.getServerHandler().field_147369_b.func_71005_bN());
            }
            if (te instanceof BlockJukebox.TileEntityJukebox) {
                InventoryBasic ib = new InventoryBasic("minecraft:jukebox", false, 1);
                ib.func_70299_a(0, ((BlockJukebox.TileEntityJukebox)te).func_145856_a());
                return new PlainInventory(message.pos, (IInventory)ib).setName(Blocks.field_150421_aI.func_149739_a());
            }
            if (te instanceof TileEntityChest) {
                Block b = world.func_180495_p(message.pos).func_177230_c();
                if (b instanceof BlockChest) {
                    ILockableContainer i = ((BlockChest)b).func_180676_d((World)world, message.pos);
                    if (i != null) {
                        return new PlainInventory(message.pos, (IInventory)i);
                    }
                    return null;
                }
                return new PlainInventory(message.pos, (IInventory)((TileEntityChest)te));
            }
            if (te instanceof IInventory) {
                return new PlainInventory(message.pos, (IInventory)te);
            }
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler iih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (iih == null) {
                    HoloInventory.getLogger().warn("Error: Block at {} (Class: {} Te: {} Block: {}) returned null after indicating the capability is available.", (Object)message.pos, (Object)te.getClass().getName(), (Object)te, (Object)te.func_145838_q());
                    return null;
                }
                if (te instanceof INamedItemHandler) {
                    INamedItemHandler namedHandler = (INamedItemHandler)te;
                    return new PlainInventory(message.pos, namedHandler.getItemHandlerName(), iih);
                }
                return new PlainInventory(message.pos, te.func_145838_q().func_149739_a(), iih);
            }
            return null;
        }
    }
}

