/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network.request;

import io.netty.buffer.ByteBuf;
import net.dries007.holoInventory.network.request.RequestMessage;
import net.dries007.holoInventory.network.response.MerchantRecipes;
import net.dries007.holoInventory.network.response.PlainInventory;
import net.dries007.holoInventory.network.response.ResponseMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EntityRequest
extends RequestMessage {
    private int id;

    public EntityRequest() {
    }

    public EntityRequest(int dimension, int id) {
        super(dimension);
        this.id = id;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.id = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<EntityRequest, ResponseMessage> {
        public ResponseMessage onMessage(EntityRequest message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world == null) {
                return null;
            }
            Entity entity = world.func_73045_a(message.id);
            if (entity == null) {
                return null;
            }
            if (entity instanceof IInventory) {
                return new PlainInventory(message.id, (IInventory)entity);
            }
            if (entity instanceof IMerchant) {
                return new MerchantRecipes(message.id, (IMerchant)entity, ctx.getServerHandler().field_147369_b);
            }
            if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                return new PlainInventory(message.id, entity.func_70005_c_(), (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            }
            return null;
        }
    }
}

