/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import net.dries007.holoInventory.Helper;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.client.renderers.FakeRenderer;
import net.dries007.holoInventory.client.renderers.IRenderer;
import net.dries007.holoInventory.client.renderers.RenderHelper;
import net.dries007.holoInventory.network.request.EntityRequest;
import net.dries007.holoInventory.network.request.TileRequest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    public static final DecimalFormat DF = new DecimalFormat("#.#");
    public static final int TEXT_COLOR = -1;
    public static final int TEXT_COLOR_LIGHT = -1;
    private static final Cache<BlockPos, IRenderer> TILE_CACHE = CacheBuilder.newBuilder().maximumSize(150L).expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();
    private static final Cache<Integer, IRenderer> ENTITY_CACHE = CacheBuilder.newBuilder().maximumSize(150L).expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();
    private static ClientEventHandler instance;
    private static boolean enabled;
    private static boolean toggleState;
    private static KeyBinding keyHold;
    private static KeyBinding keyToggle;
    private WeakReference<WorldClient> worldRef = new WeakReference<Object>(null);

    private ClientEventHandler() {
    }

    public static void init() {
        if (instance != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)instance);
        }
        instance = new ClientEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        keyHold = new KeyBinding("Hold to show", (IKeyConflictContext)KeyConflictContext.IN_GAME, 35, "holoinventory");
        keyToggle = new KeyBinding("Toggle to show", (IKeyConflictContext)KeyConflictContext.IN_GAME, 0, "holoinventory");
        ClientRegistry.registerKeyBinding((KeyBinding)keyHold);
        ClientRegistry.registerKeyBinding((KeyBinding)keyToggle);
    }

    public static void cache(BlockPos pos, IRenderer iRenderer) {
        TILE_CACHE.put((Object)pos, (Object)iRenderer);
    }

    public static void cache(int id, IRenderer iRenderer) {
        ENTITY_CACHE.put((Object)id, (Object)iRenderer);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (keyToggle.func_151468_f()) {
            boolean bl = toggleState = !toggleState;
        }
        if (keyHold.func_151470_d()) {
            enabled = true;
        }
    }

    @SubscribeEvent
    public void updateEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        WorldClient mcWorld = Minecraft.func_71410_x().field_71441_e;
        if (mcWorld == null) {
            return;
        }
        WorldClient world = (WorldClient)this.worldRef.get();
        if (world == null || mcWorld != world) {
            TILE_CACHE.invalidateAll();
            ENTITY_CACHE.invalidateAll();
            this.worldRef = new WeakReference<WorldClient>(mcWorld);
            return;
        }
        boolean bl = enabled = Helper.showOnSneak && mc.field_71474_y.field_74311_E.func_151470_d() || Helper.showOnSprint && mc.field_71474_y.field_151444_V.func_151470_d() || keyHold.func_151463_i() != 0 && keyHold.func_151470_d() || keyToggle.func_151463_i() != 0 && toggleState || !Helper.showOnSneak && !Helper.showOnSprint && keyHold.func_151463_i() == 0 && keyToggle.func_151463_i() == 0;
        if (!enabled) {
            return;
        }
        TILE_CACHE.cleanUp();
        ENTITY_CACHE.cleanUp();
        RayTraceResult ray = mc.field_71476_x;
        if (ray == null) {
            return;
        }
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tileEntity = world.func_175625_s(ray.func_178782_a());
            if (tileEntity == null || !Helper.accept(tileEntity) || Helper.banned.contains(tileEntity.getClass().getCanonicalName())) {
                return;
            }
            HoloInventory.getSnw().sendToServer((IMessage)new TileRequest(world.field_73011_w.getDimension(), ray.func_178782_a()));
        } else if (ray.field_72313_a == RayTraceResult.Type.ENTITY && Helper.accept(ray.field_72308_g)) {
            HoloInventory.getSnw().sendToServer((IMessage)new EntityRequest(world.field_73011_w.getDimension(), ray.field_72308_g.func_145782_y()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderEvent(RenderWorldLastEvent event) {
        if (this.worldRef.get() == null || !enabled) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult ray = mc.field_71476_x;
        if (ray == null) {
            return;
        }
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            IRenderer renderer = (IRenderer)TILE_CACHE.getIfPresent((Object)ray.func_178782_a());
            if (renderer == null || !renderer.shouldRender()) {
                return;
            }
            try {
                RenderHelper.start();
                renderer.render((WorldClient)this.worldRef.get(), ray, ray.field_72307_f);
            }
            catch (Exception e) {
                HoloInventory.getLogger().warn("Some error while rendering the hologram :(");
                HoloInventory.getLogger().warn("INFO: Block @ {}", (Object)ray.func_178782_a());
                HoloInventory.getLogger().warn("Please make an issue on github if this happens.");
                HoloInventory.getLogger().catching((Throwable)e);
                TILE_CACHE.put((Object)ray.func_178782_a(), (Object)new FakeRenderer());
            }
            finally {
                RenderHelper.end();
            }
        } else if (ray.field_72313_a == RayTraceResult.Type.ENTITY) {
            IRenderer renderer = (IRenderer)ENTITY_CACHE.getIfPresent((Object)ray.field_72308_g.func_145782_y());
            if (renderer == null || !renderer.shouldRender()) {
                return;
            }
            try {
                RenderHelper.start();
                renderer.render((WorldClient)this.worldRef.get(), ray, ray.field_72307_f);
            }
            catch (Exception e) {
                HoloInventory.getLogger().warn("Some error while rendering the hologram :(");
                HoloInventory.getLogger().warn("INFO: Entity: {}", (Object)ray.field_72308_g);
                HoloInventory.getLogger().warn("Please make an issue on github if this happens.");
                HoloInventory.getLogger().catching((Throwable)e);
                ENTITY_CACHE.put((Object)ray.field_72308_g.func_145782_y(), (Object)new FakeRenderer());
            }
            finally {
                RenderHelper.end();
            }
        }
    }

    static {
        enabled = true;
        toggleState = true;
    }
}

