/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolspower.blocks.InformationScreenTileEntity;
import mcjty.rftoolspower.network.PacketMonitorLogReady;
import mcjty.rftoolspower.network.RFToolsPowerMessages;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetMonitorLog
implements IMessage {
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketGetMonitorLog() {
    }

    public PacketGetMonitorLog(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetMonitorLog(BlockPos pos) {
        this.pos = pos;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            TileEntity te = player.func_130014_f_().func_175625_s(this.pos);
            if (te instanceof InformationScreenTileEntity) {
                InformationScreenTileEntity info = (InformationScreenTileEntity)te;
                EnergyTools.EnergyLevel power = info.getPower();
                RFToolsPowerMessages.INSTANCE.sendTo((IMessage)new PacketMonitorLogReady(this.pos, power, info.getRfInsertedPerTick(), info.getRfExtractPerTick(), info.calculateRoughMaxRfPerTick()), player);
            }
        });
        ctx.setPacketHandled(true);
    }
}

