/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.tile;

import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.MovingAverage;
import com.vladmarica.energymeters.Util;
import com.vladmarica.energymeters.block.BlockEnergyMeter;
import com.vladmarica.energymeters.block.Blocks;
import com.vladmarica.energymeters.energy.EnergyType;
import com.vladmarica.energymeters.energy.IEnergyMeter;
import com.vladmarica.energymeters.integration.ComputerComponent;
import com.vladmarica.energymeters.network.BufferUtil;
import com.vladmarica.energymeters.network.PacketEnergyTransferRate;
import com.vladmarica.energymeters.tile.config.EnumRedstoneControlState;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Optional.Interface(modid="opencomputers", iface="li.cil.oc.api.network.SimpleComponent")
public abstract class TileEntityEnergyMeterBase
extends TileEntity
implements ITickable,
IEnergyMeter,
SimpleComponent {
    protected static final double PACKET_RANGE = 32.0;
    protected static final double UPDATE_PACKET_MAX_TICK_INTERVAL = 120.0;
    protected static final double UPDATE_PACKET_MIN_TICK_INTERVAL = 4.0;
    protected static final String COMPUTER_COMPONENT_NAME = "energy-meter";
    public static final int UNLIMITED_RATE = -1;
    protected static final String NBT_CONNECTED_KEY = "connected";
    protected static final String NBT_POWERED_KEY = "powered";
    protected static final String NBT_INPUT_SIDE_KEY = "input-side";
    protected static final String NBT_OUTPUT_SIDE_KEY = "output-side";
    protected static final String NBT_TOTAL_ENERGY_TRANSFERRED_KEY = "total-energy-transferred";
    protected static final String NBT_REDSTONE_CONTROL_STATE = "redstone-control-state";
    protected static final String NBT_ENERGY_ALIAS = "energy-alias";
    protected static final String NBT_RATE_LIMIT_KEY = "rate-limit";
    protected static final String NBT_OWNER_UUID = "owner-uuid";
    protected static final String NBT_OWNER_USERNAME = "owner-username";
    protected int ticks = 0;
    protected long totalEnergyTransferred = 0L;
    protected long totalEnergyTransferredLastTick = 0L;
    protected float transferRate = 0.0f;
    protected float lastTransferRateSent = 0.0f;
    protected int ticksSinceLastTransferRatePacket = 0;
    protected EnergyType energyType;
    protected boolean saved = false;
    protected boolean fullyConnected = false;
    protected boolean powered = false;
    protected MovingAverage transferRateMovingAverage = new MovingAverage(10);
    protected EnumFacing screenSide = EnumFacing.NORTH;
    @Nullable
    protected EnumFacing inputSide;
    @Nullable
    protected EnumFacing outputSide;
    protected EnumRedstoneControlState redstoneControlState = EnumRedstoneControlState.ACTIVE;
    protected EnergyType.EnergyAlias energyAlias;
    protected int rateLimit = -1;
    protected NetworkRegistry.TargetPoint packetTargetPoint;
    private ComputerComponent computerComponent;

    public TileEntityEnergyMeterBase(EnergyType energyType) {
        this.energyType = energyType;
        this.energyAlias = energyType.getDefaultAlias();
        this.computerComponent = new ComputerComponent(this);
    }

    @Nullable
    public ComputerComponent getComputerComponent() {
        return this.computerComponent;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputSide = BufferUtil.decodeNullableFace(tag.func_74771_c(NBT_INPUT_SIDE_KEY));
        this.outputSide = BufferUtil.decodeNullableFace(tag.func_74771_c(NBT_OUTPUT_SIDE_KEY));
        this.totalEnergyTransferred = tag.func_74763_f(NBT_TOTAL_ENERGY_TRANSFERRED_KEY);
        this.redstoneControlState = EnumRedstoneControlState.values()[tag.func_74762_e(NBT_REDSTONE_CONTROL_STATE)];
        this.energyAlias = this.energyType.getAlias(tag.func_74762_e(NBT_ENERGY_ALIAS));
        this.rateLimit = tag.func_74762_e(NBT_RATE_LIMIT_KEY);
        this.totalEnergyTransferredLastTick = this.totalEnergyTransferred;
        this.saved = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        tag.func_74774_a(NBT_INPUT_SIDE_KEY, BufferUtil.encodeNullableFace(this.inputSide));
        tag.func_74774_a(NBT_OUTPUT_SIDE_KEY, BufferUtil.encodeNullableFace(this.outputSide));
        tag.func_74772_a(NBT_TOTAL_ENERGY_TRANSFERRED_KEY, this.totalEnergyTransferred);
        tag.func_74768_a(NBT_REDSTONE_CONTROL_STATE, this.redstoneControlState.ordinal());
        tag.func_74768_a(NBT_ENERGY_ALIAS, this.energyAlias.getIndex());
        tag.func_74768_a(NBT_RATE_LIMIT_KEY, this.rateLimit);
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74757_a(NBT_CONNECTED_KEY, this.fullyConnected);
        tag.func_74757_a(NBT_POWERED_KEY, this.powered);
        tag.func_74774_a(NBT_INPUT_SIDE_KEY, BufferUtil.encodeNullableFace(this.inputSide));
        tag.func_74774_a(NBT_OUTPUT_SIDE_KEY, BufferUtil.encodeNullableFace(this.outputSide));
        tag.func_74772_a(NBT_TOTAL_ENERGY_TRANSFERRED_KEY, this.totalEnergyTransferred);
        tag.func_74768_a(NBT_REDSTONE_CONTROL_STATE, this.redstoneControlState.ordinal());
        tag.func_74768_a(NBT_ENERGY_ALIAS, this.energyAlias.getIndex());
        tag.func_74768_a(NBT_RATE_LIMIT_KEY, this.rateLimit);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.fullyConnected = tag.func_74767_n(NBT_CONNECTED_KEY);
        this.powered = tag.func_74767_n(NBT_POWERED_KEY);
        this.inputSide = BufferUtil.decodeNullableFace(tag.func_74771_c(NBT_INPUT_SIDE_KEY));
        this.outputSide = BufferUtil.decodeNullableFace(tag.func_74771_c(NBT_OUTPUT_SIDE_KEY));
        this.totalEnergyTransferred = tag.func_74763_f(NBT_TOTAL_ENERGY_TRANSFERRED_KEY);
        this.redstoneControlState = EnumRedstoneControlState.values()[tag.func_74762_e(NBT_REDSTONE_CONTROL_STATE)];
        this.energyAlias = this.energyType.getAlias(tag.func_74762_e(NBT_ENERGY_ALIAS));
        this.rateLimit = tag.func_74762_e(NBT_RATE_LIMIT_KEY);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
        this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public void onLoad() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.screenSide = (EnumFacing)state.func_177229_b((IProperty)BlockEnergyMeter.PROP_FACING);
        if (!this.saved) {
            this.inputSide = Util.getLeftFace(this.screenSide);
            this.outputSide = Util.getRightFace(this.screenSide);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.packetTargetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0);
            this.checkConnections();
            this.checkRedstone();
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long transferredThisTick = Math.abs(this.totalEnergyTransferred - this.totalEnergyTransferredLastTick);
        this.transferRateMovingAverage.add(transferredThisTick);
        this.transferRate = this.transferRateMovingAverage.getAverage();
        this.totalEnergyTransferredLastTick = this.totalEnergyTransferred;
        if (transferredThisTick > 0L) {
            this.func_70296_d();
        }
        if ((this.transferRate != this.lastTransferRateSent || this.transferRate > 0.0f) && (double)this.ticksSinceLastTransferRatePacket > 4.0 || (double)this.ticksSinceLastTransferRatePacket >= 120.0) {
            this.lastTransferRateSent = this.transferRate;
            this.ticksSinceLastTransferRatePacket = 0;
            EnergyMetersMod.NETWORK.sendToAllTracking((IMessage)new PacketEnergyTransferRate(this.field_174879_c, this.transferRate, this.totalEnergyTransferred), this.packetTargetPoint);
        } else {
            ++this.ticksSinceLastTransferRatePacket;
        }
        if (this.ticks % 10 == 0) {
            this.checkConnections();
        }
        ++this.ticks;
        this.ticks %= 20;
    }

    public EnumRedstoneControlState getRedstoneControlState() {
        return this.redstoneControlState;
    }

    public void setRedstoneControlState(EnumRedstoneControlState redstoneControlState) {
        this.redstoneControlState = redstoneControlState;
    }

    public EnergyType getEnergyType() {
        return this.energyType;
    }

    public EnergyType.EnergyAlias getEnergyAlias() {
        return this.energyAlias;
    }

    public void setEnergyAlias(EnergyType.EnergyAlias alias) {
        if (alias.getEnergyType() != this.energyType) {
            EnergyMetersMod.LOGGER.error("Tried to set alias of type {} to meter of type {}", (Object)alias.getEnergyType().getName(), (Object)this.energyType.getName());
            return;
        }
        this.energyAlias = alias;
    }

    public boolean isDisabled() {
        return !this.redstoneControlState.isMachineEnabled(this.powered);
    }

    protected void notifyUpdate() {
        IBlockState currentBlockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, currentBlockState, currentBlockState, 3);
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)Blocks.ENERGY_METER, false);
    }

    public abstract int getEnergyScale();

    protected abstract void checkConnections();

    protected void checkRedstone() {
        boolean newPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (newPowered != this.powered) {
            this.powered = newPowered;
            this.notifyUpdate();
        }
    }

    public void onNeighborChanged(BlockPos neighborPos, IBlockState newState) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.checkConnections();
        this.checkRedstone();
    }

    public void setTransferRate(float rate) {
        this.transferRate = rate;
    }

    public float getTransferRate() {
        return this.transferRate;
    }

    public void setTotalEnergyTransferred(long totalEnergyTransferred) {
        this.totalEnergyTransferred = totalEnergyTransferred;
    }

    public long getTotalEnergyTransferred() {
        return this.totalEnergyTransferred;
    }

    public EnumFacing getScreenSide() {
        return this.screenSide;
    }

    @Nullable
    public EnumFacing getInputSide() {
        return this.inputSide;
    }

    @Nullable
    public EnumFacing getOutputSide() {
        return this.outputSide;
    }

    public void setInputSide(@Nullable EnumFacing side) {
        if (side == this.screenSide) {
            throw new IllegalArgumentException("Cannot set input side to screen side");
        }
        this.inputSide = side;
    }

    public void setOutputSide(@Nullable EnumFacing side) {
        if (side == this.screenSide) {
            throw new IllegalArgumentException("Cannot set output side to screen side");
        }
        this.outputSide = side;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public void setRateLimit(int limit) {
        this.rateLimit = limit;
    }

    public void handleSideUpdateRequest(@Nullable EnumFacing inputSide, @Nullable EnumFacing outputSide) {
        if (this.field_145850_b.field_72995_K) {
            throw new IllegalStateException("Should not have received side update packet on the client");
        }
        this.setInputSide(inputSide);
        this.setOutputSide(outputSide);
        this.checkConnections();
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)Blocks.ENERGY_METER, false);
    }

    public void handleConfigUpdateRequest(EnumRedstoneControlState redstoneControlState, int energyAliasIndex) {
        if (this.field_145850_b.field_72995_K) {
            throw new IllegalStateException("Should not have received config update packet on the client");
        }
        this.redstoneControlState = redstoneControlState;
        this.setEnergyAlias(this.energyType.getAlias(energyAliasIndex));
        if (!this.energyAlias.isAvailable()) {
            this.energyAlias = this.energyType.getDefaultAlias();
        }
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)Blocks.ENERGY_METER, false);
    }

    public void handleRateLimitChangeRequest(int newRateLimit) {
        if (this.field_145850_b.field_72995_K) {
            throw new IllegalStateException("Should not have received rate limit update packet on the client");
        }
        if (newRateLimit < 0 && newRateLimit != -1) {
            newRateLimit = -1;
        }
        this.rateLimit = newRateLimit;
        this.checkConnections();
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)Blocks.ENERGY_METER, false);
    }

    public boolean isFullyConnected() {
        return this.fullyConnected;
    }

    public boolean canReceive(EnumFacing side) {
        return side == this.inputSide && this.isFullyConnected() && !this.isDisabled();
    }

    protected boolean doesSideAcceptConnection(EnumFacing facing) {
        return facing == this.inputSide || facing == this.outputSide;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "energy_meter";
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():number -- gets the current average energy transfer rate per tick")
    public Object[] getTransferRate(Context context, Arguments args) throws Exception {
        return this.computerComponent.getTransferRate();
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():number -- gets the total energy transferred though this meter")
    public Object[] getTotalEnergyTransferred(Context context, Arguments args) throws Exception {
        return this.computerComponent.getTotalEnergyTransferred();
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():string -- returns the status of this meter, either \"active\", \"not_connected\", or \"disabled\"")
    public Object[] getStatus(Context context, Arguments args) throws Exception {
        return this.computerComponent.getStatus();
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():string -- returns the current redstone control state")
    public Object[] getRedstoneControlState(Context context, Arguments args) throws Exception {
        return this.computerComponent.getRedstoneControlState();
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():string -- returns the energy type, such as \"FE\" or \"MJ\"")
    public Object[] getEnergyType(Context context, Arguments args) throws Exception {
        return this.computerComponent.getEnergyType();
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():string -- returns the current energy type alias, such as \"RF\"")
    public Object[] getEnergyTypeAlias(Context context, Arguments args) throws Exception {
        return this.computerComponent.getEnergyTypeAlias();
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function():number -- returns the current transfer rate limit or -1 if it is unlimited")
    public Object[] getTransferRateLimit(Context context, Arguments args) throws Exception {
        return this.computerComponent.getTransferRateLimit();
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(limit:number):bool -- attempts to set the transfer rate limit for this meter. Pass -1 to set it to unlimited. Returns a boolean indicating success.")
    public Object[] setTransferRateLimit(Context context, Arguments args) throws Exception {
        return this.computerComponent.setTransferRateLimit(args.checkInteger(0));
    }
}

