/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.network;

import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.network.BufferUtil;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import com.vladmarica.energymeters.tile.config.EnumRedstoneControlState;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateMeterConfig
implements IMessage {
    private BlockPos pos;
    private EnumRedstoneControlState redstoneControlState;
    private int energyAliasIndex;

    public PacketUpdateMeterConfig() {
    }

    public PacketUpdateMeterConfig(BlockPos pos, EnumRedstoneControlState redstoneControlState, int energyAliasIndex) {
        this.pos = pos;
        this.redstoneControlState = redstoneControlState;
        this.energyAliasIndex = energyAliasIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BufferUtil.readBlockPos(buf);
        this.redstoneControlState = EnumRedstoneControlState.values()[buf.readInt()];
        this.energyAliasIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        BufferUtil.writeBlockPos(buf, this.pos);
        buf.writeInt(this.redstoneControlState.ordinal());
        buf.writeInt(this.energyAliasIndex);
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateMeterConfig, IMessage> {
        public IMessage onMessage(PacketUpdateMeterConfig message, MessageContext ctx) {
            BlockPos pos = message.pos;
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                if (!world.func_175667_e(pos)) {
                    EnergyMetersMod.LOGGER.error("Recieved PacketUpdateMeterSides for unloaded position {}", (Object)pos);
                    return;
                }
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityEnergyMeterBase) {
                    ((TileEntityEnergyMeterBase)tile).handleConfigUpdateRequest(message.redstoneControlState, message.energyAliasIndex);
                    EnergyMetersMod.LOGGER.info("Recieved PacketUpdateMeterConfig for {}", (Object)pos);
                } else {
                    EnergyMetersMod.LOGGER.error("Recieved PacketUpdateMeterConfig for position with no TE: {}", (Object)pos);
                }
            });
            return null;
        }
    }
}

