/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.client;

import com.google.common.collect.Iterators;
import com.vladmarica.energymeters.CommonProxy;
import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.block.BlockEnergyMeter;
import com.vladmarica.energymeters.block.Blocks;
import com.vladmarica.energymeters.client.EnergyMeterScreenRenderer;
import com.vladmarica.energymeters.client.gui.GuiEnergyMeter;
import com.vladmarica.energymeters.client.model.EnergyMeterBakedModel;
import com.vladmarica.energymeters.client.model.TexturedQuadCache;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnergyMeterBase.class, (TileEntitySpecialRenderer)new EnergyMeterScreenRenderer());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public boolean handleEnergyBlockActivation(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityEnergyMeterBase) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiEnergyMeter((TileEntityEnergyMeterBase)tile));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        Blocks.ENERGY_METER.registerItemModel(Item.func_150898_a((Block)Blocks.ENERGY_METER));
    }

    @SubscribeEvent
    public void onModelBaking(ModelBakeEvent event) {
        Map variantToModelMap = event.getModelManager().func_174954_c().func_178120_a().func_188181_b((Block)Blocks.ENERGY_METER);
        HashMap<BlockEnergyMeter.MeterType, IBlockState> meterTypeToStateMap = new HashMap<BlockEnergyMeter.MeterType, IBlockState>();
        for (IBlockState state : variantToModelMap.keySet()) {
            BlockEnergyMeter.MeterType type = (BlockEnergyMeter.MeterType)((Object)state.func_177229_b(BlockEnergyMeter.PROP_TYPE));
            if (meterTypeToStateMap.containsKey((Object)type)) continue;
            meterTypeToStateMap.put(type, state);
        }
        HashMap<EnumFacing, BakedQuad> cubeQuadMap = new HashMap<EnumFacing, BakedQuad>();
        HashMap<ResourceLocation, TextureAtlasSprite> spriteMap = new HashMap<ResourceLocation, TextureAtlasSprite>();
        IBakedModel originalModel = null;
        for (Map.Entry meterTypeStatePair : meterTypeToStateMap.entrySet()) {
            IBlockState state = (IBlockState)meterTypeStatePair.getValue();
            ModelResourceLocation modelLocation = (ModelResourceLocation)variantToModelMap.get(state);
            IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelLocation);
            if (originalModel == null) {
                originalModel = model;
            }
            EnergyMetersMod.LOGGER.debug("Extracting textures for meter type {}", meterTypeStatePair.getKey());
            for (EnumFacing side : EnumFacing.values()) {
                List quads = model.func_188616_a(state, side, 0L);
                BakedQuad quad = (BakedQuad)Iterators.getOnlyElement(quads.iterator());
                EnergyMetersMod.LOGGER.debug("Side {} has texture {}", (Object)side.func_176610_l(), (Object)quad.func_187508_a());
                ResourceLocation spriteLocation = new ResourceLocation(quad.func_187508_a().func_94215_i());
                if (!spriteMap.containsKey(spriteLocation)) {
                    spriteMap.put(spriteLocation, quad.func_187508_a());
                }
                cubeQuadMap.put(side, quad);
            }
        }
        TexturedQuadCache.INSTANCE.setCubeQuadMap(cubeQuadMap);
        TexturedQuadCache.INSTANCE.setTextureMap(spriteMap);
        for (Map.Entry entry : variantToModelMap.entrySet()) {
            event.getModelRegistry().func_82595_a((Object)((ModelResourceLocation)entry.getValue()), (Object)new EnergyMeterBakedModel(originalModel));
        }
    }
}

