/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters;

import java.util.LinkedList;

public class MovingAverage {
    private long sum = 0L;
    private int count = 0;
    private int maxCount;
    private LinkedList<Long> values;

    public MovingAverage(int maxCount) {
        if (maxCount < 1) {
            throw new IllegalArgumentException("maxCount must be at least 1");
        }
        this.maxCount = maxCount;
        this.values = new LinkedList();
    }

    public void add(long value) {
        this.sum += value;
        this.values.addLast(value);
        if (this.count == this.maxCount) {
            this.sum -= this.values.removeFirst().longValue();
        } else {
            ++this.count;
        }
    }

    public float getAverage() {
        if (this.count == 0) {
            return 0.0f;
        }
        return (float)this.sum / (float)this.count;
    }
}

