/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.api.parameters.Tuple;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class TupleEditor
extends AbstractParameterEditor {
    private TextField fieldX;
    private TextField fieldY;

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new HorizontalLayout());
        this.fieldX = new TextField(mc, gui).addTextEvent((parent, newText) -> callback.valueChanged(this.readValue())).addTextEnterEvent((parent, newText) -> this.closeWindow());
        this.fieldY = new TextField(mc, gui).addTextEvent((parent, newText) -> callback.valueChanged(this.readValue())).addTextEnterEvent((parent, newText) -> this.closeWindow());
        ((Panel)constantPanel.addChild((Widget)this.fieldX)).addChild((Widget)this.fieldY);
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_TUPLE);
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.fieldX);
    }

    @Override
    protected ParameterValue readConstantValue() {
        Integer x = TupleEditor.parseIntSafe(this.fieldX.getText());
        Integer y = TupleEditor.parseIntSafe(this.fieldY.getText());
        return ParameterValue.constant(new Tuple(x == null ? 0 : x, y == null ? 0 : y));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.fieldX.setText("");
            this.fieldY.setText("");
        } else {
            Tuple tuple = (Tuple)value.getValue();
            try {
                this.fieldX.setText(Integer.toString(tuple.getX()));
                this.fieldY.setText(Integer.toString(tuple.getY()));
            }
            catch (Exception e) {
                this.fieldX.setText("");
                this.fieldY.setText("");
            }
        }
    }
}

