/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.org.kamranzafar.jtar;

import aroma1997.org.kamranzafar.jtar.TarUtils;
import java.io.File;

public class TarHeader {
    public static final int NAMELEN = 100;
    public static final int MODELEN = 8;
    public static final int UIDLEN = 8;
    public static final int GIDLEN = 8;
    public static final int SIZELEN = 12;
    public static final int MODTIMELEN = 12;
    public static final int CHKSUMLEN = 8;
    public static final byte LF_OLDNORM = 0;
    public static final byte LF_NORMAL = 48;
    public static final byte LF_LINK = 49;
    public static final byte LF_SYMLINK = 50;
    public static final byte LF_CHR = 51;
    public static final byte LF_BLK = 52;
    public static final byte LF_DIR = 53;
    public static final byte LF_FIFO = 54;
    public static final byte LF_CONTIG = 55;
    public static final String USTAR_MAGIC = "ustar";
    public static final int USTAR_MAGICLEN = 8;
    public static final int USTAR_USER_NAMELEN = 32;
    public static final int USTAR_GROUP_NAMELEN = 32;
    public static final int USTAR_DEVLEN = 8;
    public static final int USTAR_FILENAME_PREFIX = 155;
    public StringBuffer name;
    public int mode;
    public int userId;
    public int groupId;
    public long size;
    public long modTime;
    public int checkSum;
    public byte linkFlag;
    public StringBuffer linkName;
    public StringBuffer magic = new StringBuffer("ustar");
    public StringBuffer userName;
    public StringBuffer groupName;
    public int devMajor;
    public int devMinor;
    public StringBuffer namePrefix;

    public TarHeader() {
        this.name = new StringBuffer();
        this.linkName = new StringBuffer();
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.userId = 0;
        this.groupId = 0;
        this.userName = new StringBuffer(user);
        this.groupName = new StringBuffer("");
        this.namePrefix = new StringBuffer();
    }

    public static StringBuffer parseName(byte[] header, int offset, int length) {
        StringBuffer result = new StringBuffer(length);
        int end = offset + length;
        for (int i = offset; i < end && header[i] != 0; ++i) {
            result.append((char)header[i]);
        }
        return result;
    }

    public static int getNameBytes(StringBuffer name, byte[] buf, int offset, int length) {
        int i;
        for (i = 0; i < length && i < name.length(); ++i) {
            buf[offset + i] = (byte)name.charAt(i);
        }
        while (i < length) {
            buf[offset + i] = 0;
            ++i;
        }
        return offset + length;
    }

    public static TarHeader createHeader(String entryName, long size, long modTime, boolean dir, int permissions) {
        String name = entryName;
        name = TarUtils.trim(name.replace(File.separatorChar, '/'), '/');
        TarHeader header = new TarHeader();
        header.linkName = new StringBuffer("");
        header.mode = permissions;
        if (name.length() > 100) {
            header.namePrefix = new StringBuffer(name.substring(0, name.lastIndexOf(47)));
            header.name = new StringBuffer(name.substring(name.lastIndexOf(47) + 1));
        } else {
            header.name = new StringBuffer(name);
        }
        if (dir) {
            header.linkFlag = (byte)53;
            if (header.name.charAt(header.name.length() - 1) != '/') {
                header.name.append("/");
            }
            header.size = 0L;
        } else {
            header.linkFlag = (byte)48;
            header.size = size;
        }
        header.modTime = modTime;
        header.checkSum = 0;
        header.devMajor = 0;
        header.devMinor = 0;
        return header;
    }
}

