/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.mc;

import aroma1997.backup.mc.AromaBackup;
import aroma1997.backup.mc.Config;
import aroma1997.backup.mc.ThreadBackup;
import aroma1997.core.command.AromaBaseCommand;
import aroma1997.core.command.AromaSubCommand;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.LocalizationHelper;
import aroma1997.core.util.ServerUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Logger;

public class CommandBackup
extends AromaSubCommand {
    CommandBackup() {
        super(new String[]{"backup", "aromabackup"});
        this.addSubCommand((CommandBase)new CommandReloadConfig());
        this.addSubCommand((CommandBase)new CommandReschedule());
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender != null && (Config.instance.allPlayers || ServerUtil.isPlayerAdmin((ICommandSender)sender));
    }

    protected List<String> addTabbCompleteOptionsSelf(MinecraftServer server, ICommandSender sender, String[] arg, BlockPos pos) {
        return Arrays.asList(ThreadBackup.BackupType.DEFAULT.toString().toLowerCase(), ThreadBackup.BackupType.FULL.toString().toLowerCase(), ThreadBackup.BackupType.INCREMENTAL.toString().toLowerCase());
    }

    protected void processCommandSelf(ICommandSender sender, String[] args) {
        ThreadBackup.BackupType type = ThreadBackup.BackupType.DEFAULT;
        if (args.length > 0) {
            for (ThreadBackup.BackupType tmp : ThreadBackup.BackupType.values()) {
                if (!args[0].equalsIgnoreCase(tmp.toString())) continue;
                type = tmp;
                args = CommandBackup.getSubArgs((String[])args);
                break;
            }
        }
        if (args.length > 0) {
            ServerUtil.printCommandUsage((ICommandSender)sender, (ICommand)this);
            return;
        }
        if (ThreadBackup.startBackup(type)) {
            LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)LocalizationHelper.localizeFormatted((String)"aromabackup:command.playerstarted", (Object[])new Object[]{sender.func_70005_c_()}));
        } else {
            LogHelper.sendMessageToPlayer((Logger)AromaBackup.instance.logger, (ICommandSender)sender, (String)LocalizationHelper.localize((String)"aromabackup:command.alreadyrunning"));
        }
    }

    private static class CommandReschedule
    extends AromaBaseCommand {
        private CommandReschedule() {
            super(new String[]{"reschedule"});
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return ServerUtil.isPlayerAdmin((ICommandSender)sender);
        }

        public String func_71518_a(ICommandSender sender) {
            return "/reschedule <time milis for the next backup>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            long time = args.length == 1 ? Long.parseLong(args[0]) : System.currentTimeMillis() + Config.instance.delay;
            ThreadBackup.executeOnServerThreadAndWait(() -> AromaBackup.instance.setupTimer(time));
        }
    }

    private static class CommandReloadConfig
    extends AromaBaseCommand {
        private CommandReloadConfig() {
            super(new String[]{"reloadconfig"});
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return ServerUtil.isPlayerAdmin((ICommandSender)sender);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            Config.instance.reload();
            sender.func_145747_a(ServerUtil.getChatForString((String)"Successfully reloaded config file."));
        }
    }
}

