/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.util;

import java.io.File;

public abstract class Environment {
    public static final boolean INDEV = System.getProperty("INDEV") != null;
    private static Environment instance;

    protected Environment() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public static Environment getEnv() {
        return instance;
    }

    public abstract File getMCDir();

    public abstract File getBackupDir();

    public abstract int getCompressionRate();

    public abstract void log(String var1);

    public void logDebug(String message) {
        if (INDEV) {
            this.log("[DEBUG] " + message);
        }
    }

    public abstract void logError(String var1);

    public File getTmpDir(String subfolder) {
        File tmp = new File(this.getMCDir(), "tmp/abackup-" + subfolder);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        return tmp;
    }

    public abstract EnvironmentType getEnvType();

    public static enum EnvironmentType {
        MINECRAFT,
        STANDALONE;

    }
}

