/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.storageformat;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.IBackupStats;
import aroma1997.backup.common.storageformat.IStorageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class BasicBackupInfo
implements IBackupInfo,
IBackupStats {
    private final File file;
    private final File infoFile;
    private final Properties additionalProperties = new Properties();
    private final IStorageFormat<?> storageFormat;

    public BasicBackupInfo(File file, IStorageFormat<?> storageFormat) {
        this(file, storageFormat, null);
    }

    public BasicBackupInfo(File file, IStorageFormat<?> storageFormat, IBackupStats stats) {
        this.file = file;
        String backupName = file.getName();
        String extension = CompressionHelper.getExtension(backupName);
        int cut = 0;
        if (!extension.isEmpty()) {
            cut = extension.length() + 1;
        }
        this.infoFile = new File(file.getParentFile(), file.getName().substring(0, backupName.length() - cut) + ".backupinfo");
        this.storageFormat = storageFormat;
        if (stats != null) {
            this.getAdditionalProperties().put("date", stats.getCreationDate().getTime() + "");
            this.getAdditionalProperties().put("world", stats.getWorldName());
        }
    }

    public void load() throws IOException {
        try (FileInputStream fis = new FileInputStream(this.infoFile);){
            this.additionalProperties.load(fis);
        }
    }

    public void save() throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.infoFile);){
            this.additionalProperties.store(fos, "=======================================================" + System.lineSeparator() + "This is an important file for your backups." + System.lineSeparator() + "Do not move, edit or delete this file." + System.lineSeparator() + "If you do, backups may not be automatically restorable." + System.lineSeparator() + "=======================================================");
        }
    }

    public boolean isValid() {
        return this.file.exists() && this.infoFile.exists();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public IBackupStats getBackupStats() {
        return this;
    }

    @Override
    public <T extends IBackupInfo> IStorageFormat<T> getStorageFormat() {
        return this.storageFormat;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public Date getCreationDate() {
        if (this.getAdditionalProperties().containsKey("date")) {
            return new Date(Long.parseLong(this.getAdditionalProperties().get("date")));
        }
        return new Date(0L);
    }

    @Override
    public String getWorldName() {
        return this.getAdditionalProperties().getOrDefault("world", "UNKNOWN");
    }

    @Override
    public void delete(File backupLocation) {
        CompressionHelper.deleteFile(this.getFile());
        CompressionHelper.deleteFile(this.infoFile);
    }
}

