/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.notification;

import aroma1997.backup.common.notification.IBackupNotification;
import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.IBackupRestoreInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public enum NotificationHelper implements IBackupNotification
{
    INSTANCE;

    private final List<IBackupNotification> notifications = new ArrayList<IBackupNotification>();

    public void registerNotification(IBackupNotification notification) {
        if (notification == INSTANCE) {
            throw new IllegalArgumentException();
        }
        this.notifications.add(notification);
    }

    public List<IBackupNotification> getRegisteredNotifications() {
        return Collections.unmodifiableList(this.notifications);
    }

    private <T> void callAll(T arg, BiConsumer<IBackupNotification, T> method) {
        this.getRegisteredNotifications().stream().forEach(notification -> method.accept((IBackupNotification)notification, arg));
    }

    @Override
    public void backupCreateStart(Map<File, String> filesToBackup) {
        this.callAll(filesToBackup, IBackupNotification::backupCreateStart);
    }

    @Override
    public void backupCreateEnd(IBackupInfo info) {
        this.callAll(info, IBackupNotification::backupCreateEnd);
    }

    @Override
    public IBackupRestoreInfo backupRestoreStart(IBackupInfo backupInfo, IBackupRestoreInfo restoreInfo) {
        return this.getRegisteredNotifications().stream().reduce(restoreInfo, (rInfo, notification) -> notification.backupRestoreStart(backupInfo, (IBackupRestoreInfo)rInfo), null);
    }

    @Override
    public void backupRestoreEnd(IBackupInfo backup) {
        this.callAll(backup, IBackupNotification::backupRestoreEnd);
    }
}

