/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.itemblocks.ItemBlockTESRMP;
import stevekung.mods.moreplanets.utils.StackSorted;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.utils.blocks.ISortableBlock;
import stevekung.mods.moreplanets.utils.client.renderer.IItemModelRender;
import stevekung.mods.moreplanets.utils.itemblocks.ItemBlockMP;
import stevekung.mods.moreplanets.utils.items.EnumSortCategoryItem;
import stevekung.mods.moreplanets.utils.items.ISortableItem;
import stevekung.mods.stevekunglib.utils.LangUtils;
import stevekung.mods.stevekunglib.utils.client.ClientUtils;

public class BlocksItemsRegistry {
    public static final Map<EnumSortCategoryBlock, List<StackSorted>> SORT_MAP_BLOCKS = new HashMap<EnumSortCategoryBlock, List<StackSorted>>();
    public static final Map<EnumSortCategoryItem, List<StackSorted>> SORT_MAP_ITEMS = new HashMap<EnumSortCategoryItem, List<StackSorted>>();
    public static final Map<Block, String> SINGLE_BLOCK_RENDER_LIST = new HashMap<Block, String>();
    public static final Map<Item, String> SINGLE_ITEM_RENDER_LIST = new HashMap<Item, String>();
    public static final List<Item> TESR_ITEM_RENDER = new ArrayList<Item>();

    public static void registerBlock(Block block) {
        BlocksItemsRegistry.registerBlock(block, (Function<Block, ItemBlock>)((Function)ItemBlockMP::new));
    }

    public static void registerBlock(Block block, @Nullable Function<Block, ItemBlock> itemBlock) {
        IItemModelRender blockRender;
        MorePlanetsMod.COMMON_REGISTRY.registerBlock(block, itemBlock);
        if (block instanceof IItemModelRender && (blockRender = (IItemModelRender)block).getName() != null) {
            SINGLE_BLOCK_RENDER_LIST.put(block, blockRender.getName());
        }
        if (itemBlock != null && ClientUtils.isEffectiveClient()) {
            BlocksItemsRegistry.registerSorted(block);
            ItemBlock itemBlockTESR = (ItemBlock)itemBlock.apply((Object)block);
            if (itemBlockTESR instanceof ItemBlockTESRMP) {
                TESR_ITEM_RENDER.add(Item.func_150898_a((Block)itemBlockTESR.func_179223_d()));
            }
        }
    }

    public static void registerItem(Item item) {
        IItemModelRender itemRender;
        MorePlanetsMod.COMMON_REGISTRY.registerItem(item);
        if (item instanceof IItemModelRender && (itemRender = (IItemModelRender)item).getName() != null) {
            SINGLE_ITEM_RENDER_LIST.put(item, itemRender.getName());
        }
        if (ClientUtils.isEffectiveClient()) {
            BlocksItemsRegistry.registerSorted(item);
            TESR_ITEM_RENDER.add(MPItems.INFECTED_PURLONITE_BOMB);
        }
    }

    public static void registerSorted(Block block) {
        if (block instanceof ISortableBlock) {
            Item item = Item.func_150898_a((Block)block);
            if (item == Items.field_190931_a) {
                return;
            }
            ISortableBlock sortableBlock = (ISortableBlock)block;
            EnumSortCategoryBlock categoryBlock = sortableBlock.getBlockCategory();
            if (!SORT_MAP_BLOCKS.containsKey((Object)categoryBlock)) {
                SORT_MAP_BLOCKS.put(categoryBlock, new ArrayList());
            }
            SORT_MAP_BLOCKS.get((Object)categoryBlock).add(new StackSorted(block));
        } else if (block.func_149708_J() == MorePlanetsMod.BLOCK_TAB) {
            throw new RuntimeException(block.getClass() + " must inherit " + ISortableBlock.class.getSimpleName() + "!");
        }
    }

    public static void postRegisteredSortBlock() {
        ArrayList<StackSorted> itemOrderListBlocks = new ArrayList<StackSorted>();
        for (EnumSortCategoryBlock type : EnumSortCategoryBlock.VALUES) {
            List<StackSorted> stackSorteds = SORT_MAP_BLOCKS.get((Object)type);
            if (stackSorteds == null) continue;
            itemOrderListBlocks.addAll(stackSorteds);
        }
        Ordering tabSorterBlocks = Ordering.explicit(itemOrderListBlocks).onResultOf(input -> new StackSorted(input.func_77973_b()));
        MorePlanetsMod.BLOCK_TAB.setTabSorter((Comparator<ItemStack>)tabSorterBlocks);
    }

    public static void registerSorted(Item item) {
        if (item instanceof ISortableItem) {
            ISortableItem sortableItem = (ISortableItem)item;
            EnumSortCategoryItem categoryItem = sortableItem.getItemCategory();
            if (!SORT_MAP_ITEMS.containsKey((Object)categoryItem)) {
                SORT_MAP_ITEMS.put(categoryItem, new ArrayList());
            }
            SORT_MAP_ITEMS.get((Object)categoryItem).add(new StackSorted(item));
        } else if (item.func_77640_w() == MorePlanetsMod.ITEM_TAB) {
            throw new RuntimeException(item.getClass() + " must inherit " + ISortableItem.class.getSimpleName() + "!");
        }
    }

    public static void postRegisteredSortItem() {
        ArrayList<StackSorted> itemOrderListItems = new ArrayList<StackSorted>();
        for (EnumSortCategoryItem type : EnumSortCategoryItem.VALUES) {
            List<StackSorted> stackSorteds = SORT_MAP_ITEMS.get((Object)type);
            if (stackSorteds == null) continue;
            itemOrderListItems.addAll(stackSorteds);
        }
        Ordering tabSorterItems = Ordering.explicit(itemOrderListItems).onResultOf(input -> new StackSorted(input.func_77973_b()));
        MorePlanetsMod.ITEM_TAB.setTabSorter((Comparator<ItemStack>)tabSorterItems);
    }

    public static boolean isItemTab(CreativeTabs creativeTabs) {
        return creativeTabs == MorePlanetsMod.ITEM_TAB || creativeTabs == CreativeTabs.field_78027_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getDescription(String name) {
        return Minecraft.func_71410_x().field_71466_p.func_78271_c(LangUtils.translate((String)name), 150);
    }
}

