/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityJuicer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureStart;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.structure.StructureNibiruPyramidPieces;
import stevekung.mods.moreplanets.utils.LoggerMP;

public class MapGenNibiruPyramid
extends MapGenStructure {
    private final List<Biome.SpawnListEntry> entitySpawnList = new ArrayList<Biome.SpawnListEntry>();
    private final int maxDistanceBetweenScatteredFeatures;
    private final int minDistanceBetweenScatteredFeatures;

    public MapGenNibiruPyramid() {
        this.maxDistanceBetweenScatteredFeatures = 32;
        this.minDistanceBetweenScatteredFeatures = 8;
        this.entitySpawnList.add(new Biome.SpawnListEntry(EntityJuicer.class, 1, 1, 1));
    }

    public String func_143025_a() {
        return "NibiruPyramid";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int k = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int l = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenScatteredFeatures;
        l *= this.maxDistanceBetweenScatteredFeatures;
        if (i == (k += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && j == (l += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures))) {
            Biome biome = this.field_75039_c.func_72959_q().func_180631_a(new BlockPos(i * 16 + 8, 0, j * 16 + 8));
            if (biome == null) {
                return false;
            }
            if (biome == MPBiomes.INFECTED_DESERT) {
                return true;
            }
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public BlockPos func_180706_b(World world, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = world;
        return MapGenStructure.func_191069_a((World)world, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenScatteredFeatures, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    public List<Biome.SpawnListEntry> getSpawnList() {
        return this.entitySpawnList;
    }

    public boolean canMobSpawn(BlockPos pos) {
        StructureStart structurestart = this.func_175797_c(pos);
        return structurestart != null && structurestart instanceof Start && !structurestart.func_186161_c().isEmpty();
    }

    static {
        MapGenStructureIO.func_143034_b(Start.class, (String)"NibiruPyramid");
        MapGenStructureIO.func_143031_a(StructureNibiruPyramidPieces.NibiruPyramid.class, (String)"NibiruPyramid");
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random rand, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            LoggerMP.debug("Generate nibiru pyramid at {} {}", chunkX * 16, chunkZ * 16);
            StructureNibiruPyramidPieces.NibiruPyramid pyramid = new StructureNibiruPyramidPieces.NibiruPyramid(rand, chunkX * 16, chunkZ * 16);
            this.field_75075_a.add(pyramid);
            this.func_75072_c();
        }
    }
}

