/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.world.gen.biome.layer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.stevekunglib.utils.enums.CachedEnum;

public class GenLayerFronosBiome
extends GenLayer {
    private final List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[CachedEnum.biomeValues.length];
    private final ArrayList<BiomeManager.BiomeEntry>[] biomesList = this.setupBiomes();

    public GenLayerFronosBiome(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
        for (BiomeManager.BiomeType type : CachedEnum.biomeValues) {
            ImmutableList<BiomeManager.BiomeEntry> biomesToAdd = this.getBiomes(type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.field_75909_a.func_75904_a(areaX, areaY, areaWidth, areaHeight);
        int[] aint1 = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.func_75903_a(j + areaX, i + areaY);
                int k = aint[j + i * areaWidth];
                k &= 0xFFFFF0FF;
                aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM).biome);
            }
        }
        return aint1;
    }

    private ArrayList<BiomeManager.BiomeEntry>[] setupBiomes() {
        ArrayList[] currentBiomes = new ArrayList[CachedEnum.biomeValues.length];
        ArrayList<BiomeManager.BiomeEntry> list = new ArrayList<BiomeManager.BiomeEntry>();
        list.add(new BiomeManager.BiomeEntry(MPBiomes.FRONOS_MEADOW, 30));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.FRONOS_PLAINS, 20));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.FRONOS_FOREST, 20));
        currentBiomes[BiomeManager.BiomeType.WARM.ordinal()] = new ArrayList(list);
        list.clear();
        list.add(new BiomeManager.BiomeEntry(MPBiomes.FRONOS_MEADOW, 30));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.FRONOS_PLAINS, 20));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.FRONOS_FOREST, 20));
        return currentBiomes;
    }

    private ImmutableList<BiomeManager.BiomeEntry> getBiomes(BiomeManager.BiomeType type) {
        int idx = type.ordinal();
        ArrayList<BiomeManager.BiomeEntry> list = idx >= this.biomesList.length ? null : this.biomesList[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    private BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

