/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.diona.world.gen.structure;

import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockBrightLamp;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineTiered;
import micdoodle8.mods.galacticraft.core.blocks.BlockScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFallenMeteor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.planets.diona.tileentity.TileEntityCrashedAlienProbe;
import stevekung.mods.moreplanets.tileentity.TileEntityAlienChest;
import stevekung.mods.moreplanets.tileentity.TileEntityAlienDefenderBeacon;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityChestMP;
import stevekung.mods.moreplanets.utils.world.gen.feature.ElectricFireBlockProcessor;
import stevekung.mods.stevekunglib.utils.enums.CachedEnum;

public class ComponentCrashedAlienShipPieces
extends StructureComponent {
    private static final ResourceLocation ALIEN_SHIP_BRIGDE = new ResourceLocation("moreplanets:crashed_alien_ship/bridge");
    private static final ResourceLocation ALIEN_SHIP_STORAGE = new ResourceLocation("moreplanets:crashed_alien_ship/storage");
    private static final ResourceLocation ALIEN_SHIP_BOOSTER = new ResourceLocation("moreplanets:crashed_alien_ship/booster");
    protected int width;
    protected int height;
    protected int depth;
    protected int horizontalPos = -1;

    public ComponentCrashedAlienShipPieces() {
    }

    public ComponentCrashedAlienShipPieces(Random rand, int x, int z) {
        this(rand, x, 64, z, 8, 7, 8);
    }

    protected ComponentCrashedAlienShipPieces(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(0);
        this.width = sizeX;
        this.height = sizeY;
        this.depth = sizeZ;
        this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        nbt.func_74768_a("Width", this.width);
        nbt.func_74768_a("Height", this.height);
        nbt.func_74768_a("Depth", this.depth);
        nbt.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        this.width = nbt.func_74762_e("Width");
        this.height = nbt.func_74762_e("Height");
        this.depth = nbt.func_74762_e("Depth");
        this.horizontalPos = nbt.func_74762_e("HPos");
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox structureBoundingBox) {
        if (!this.offsetToAverageGroundLevel(world, structureBoundingBox, -1)) {
            return false;
        }
        StructureBoundingBox box = this.func_74874_b();
        BlockPos pos = new BlockPos(box.field_78897_a, box.field_78895_b - 3, box.field_78896_c);
        Rotation[] arotation = CachedEnum.rotationValues;
        Rotation rotation = arotation[rand.nextInt(arotation.length)];
        MinecraftServer server = world.func_73046_m();
        TemplateManager manager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186225_a(Blocks.field_189881_dj).func_186223_a(box);
        settings.func_189946_a(0.8f);
        Template template = manager.func_186237_a(server, ALIEN_SHIP_BRIGDE);
        Template template1 = manager.func_186237_a(server, ALIEN_SHIP_STORAGE);
        Template template2 = manager.func_186237_a(server, ALIEN_SHIP_BOOSTER);
        this.addBlocksToWorldChunk(template, world, pos, settings);
        BlockPos blockpos1 = template1.func_186262_a(settings, new BlockPos(11, 0, 0), settings, new BlockPos(0, 0, 2));
        this.addBlocksToWorldChunk(template1, world, pos.func_177971_a((Vec3i)blockpos1), settings);
        BlockPos blockpos2 = pos.func_177971_a((Vec3i)template2.func_186262_a(settings, new BlockPos(27, 0, 0), settings, new BlockPos(0, 0, 2)));
        this.addBlocksToWorldChunk(template2, world, blockpos2, settings);
        ComponentCrashedAlienShipPieces.replaceDataBlocks1(world, rand, rotation, template, pos, settings);
        ComponentCrashedAlienShipPieces.replaceDataBlocks2(world, rand, rotation, template1, pos.func_177971_a((Vec3i)blockpos1), settings);
        ComponentCrashedAlienShipPieces.replaceDataBlocks3(world, rand, rotation, template2, blockpos2, settings);
        return true;
    }

    private static void replaceDataBlocks1(World world, Random rand, Rotation rotation, Template template, BlockPos pos, PlacementSettings settings) {
        Map map = template.func_186258_a(pos, settings);
        for (Map.Entry entry : map.entrySet()) {
            String dataName = (String)entry.getValue();
            BlockPos dataPos = (BlockPos)entry.getKey();
            if ("crashed_alien_probe".equals(dataName)) {
                world.func_180501_a(dataPos, MPBlocks.ALIEN_DEFENDER_BEACON.func_176223_P(), 3);
                TileEntity tile = world.func_175625_s(dataPos);
                TileEntity tileDown = world.func_175625_s(dataPos.func_177977_b());
                if (tile instanceof TileEntityAlienDefenderBeacon) {
                    ((TileEntityAlienDefenderBeacon)tile).creativeSpawn = true;
                }
                if (!(tileDown instanceof TileEntityCrashedAlienProbe)) continue;
                ((TileEntityCrashedAlienProbe)tileDown).setLootTable(MPLootTables.CRASHED_ALIEN_PROBE, rand.nextLong());
                continue;
            }
            if (!"alien_chest".equals(dataName)) continue;
            world.func_180501_a(dataPos, Blocks.field_150350_a.func_176223_P(), 3);
            TileEntity tileDown = world.func_175625_s(dataPos.func_177977_b());
            if (!(tileDown instanceof TileEntityAlienChest)) continue;
            ((TileEntityAlienChest)tileDown).func_189404_a(MPLootTables.CRASHED_ALIEN_SHIP, rand.nextLong());
        }
    }

    private static void replaceDataBlocks2(World world, Random rand, Rotation rotation, Template template, BlockPos pos, PlacementSettings settings) {
        Map map = template.func_186258_a(pos, settings);
        for (Map.Entry entry : map.entrySet()) {
            TileEntity tile;
            String dataName = (String)entry.getValue();
            BlockPos dataPos = (BlockPos)entry.getKey();
            if ("airlock".equals(dataName)) {
                world.func_180501_a(dataPos, GCBlocks.airLockFrame.func_176203_a(1), 3);
                tile = world.func_175625_s(dataPos);
                if (!(tile instanceof TileEntityAirLockController)) continue;
                ((TileEntityAirLockController)tile).playerDistanceSelection = 1;
                continue;
            }
            if ("chest_or_crystals".equals(dataName)) {
                if (rand.nextFloat() > 0.95f) {
                    world.func_180501_a(dataPos, MPBlocks.ALIEN_CHEST.func_176223_P().func_185907_a(rotation), 3);
                    tile = world.func_175625_s(dataPos);
                    if (!(tile instanceof TileEntityChestMP)) continue;
                    ((TileEntityChestMP)tile).func_189404_a(MPLootTables.CRASHED_ALIEN_SHIP, rand.nextLong());
                    continue;
                }
                if (rand.nextFloat() > 0.75f) {
                    world.func_180501_a(dataPos, GCBlocks.fallenMeteor.func_176223_P(), 3);
                    tile = world.func_175625_s(dataPos);
                    if (!(tile instanceof TileEntityFallenMeteor)) continue;
                    ((TileEntityFallenMeteor)tile).heatLevel = 0;
                    continue;
                }
                world.func_180501_a(dataPos, MPBlocks.INFECTED_PURLONITE_CRYSTAL.func_176223_P(), 3);
                continue;
            }
            if ("arclamp_west".equals(dataName)) {
                world.func_180501_a(dataPos, GCBlocks.brightLamp.func_176223_P().func_177226_a((IProperty)BlockBrightLamp.FACING, (Comparable)rotation.func_185831_a(EnumFacing.WEST)), 3);
                continue;
            }
            if (!"arclamp_east".equals(dataName)) continue;
            world.func_180501_a(dataPos, GCBlocks.brightLamp.func_176223_P().func_177226_a((IProperty)BlockBrightLamp.FACING, (Comparable)rotation.func_185831_a(EnumFacing.EAST)), 3);
        }
    }

    private static void replaceDataBlocks3(World world, Random rand, Rotation rotation, Template template, BlockPos pos, PlacementSettings settings) {
        Map map = template.func_186258_a(pos, settings);
        for (Map.Entry entry : map.entrySet()) {
            String dataName = (String)entry.getValue();
            BlockPos dataPos = (BlockPos)entry.getKey();
            if ("screen_west".equals(dataName)) {
                world.func_180501_a(dataPos, GCBlocks.screen.func_176223_P().func_177226_a((IProperty)BlockScreen.FACING, (Comparable)rotation.func_185831_a(EnumFacing.WEST)), 3);
                continue;
            }
            if ("energy_storage_west".equals(dataName)) {
                world.func_180501_a(dataPos, GCBlocks.machineTiered.func_176223_P().func_177226_a((IProperty)BlockMachineTiered.TYPE, (Comparable)BlockMachineTiered.EnumTieredMachineType.STORAGE_CLUSTER).func_177226_a((IProperty)BlockMachineBase.FACING, (Comparable)rotation.func_185831_a(EnumFacing.WEST)), 3);
                TileEntity tile = world.func_175625_s(dataPos);
                if (!(tile instanceof TileEntityEnergyStorageModule)) continue;
                ((TileEntityEnergyStorageModule)tile).storage.setEnergyStored((float)(100000 + rand.nextInt(500000)));
                continue;
            }
            if (!"arclamp_west".equals(dataName)) continue;
            world.func_180501_a(dataPos, GCBlocks.brightLamp.func_176223_P().func_177226_a((IProperty)BlockBrightLamp.FACING, (Comparable)rotation.func_185831_a(EnumFacing.WEST)), 3);
        }
    }

    private boolean offsetToAverageGroundLevel(World world, StructureBoundingBox bb, int yOffset) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                pos.func_181079_c(l, 64, k);
                if (!bb.func_175898_b((Vec3i)pos)) continue;
                i += Math.max(world.func_175672_r((BlockPos)pos).func_177956_o(), world.field_73011_w.func_76557_i());
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.horizontalPos = i / j;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
        return true;
    }

    private void addBlocksToWorldChunk(Template template, World world, BlockPos pos, PlacementSettings placement) {
        placement.func_186224_i();
        template.func_189960_a(world, pos, (ITemplateProcessor)new ElectricFireBlockProcessor(pos, placement), placement, 2);
    }
}

