/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.inventory.ContainerShieldGenerator;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.utils.client.gui.GuiContainerMP;
import stevekung.mods.moreplanets.utils.client.gui.GuiElementInfoRegionMP;
import stevekung.mods.stevekunglib.utils.LangUtils;
import stevekung.mods.stevekunglib.utils.NumberUtils;

@SideOnly(value=Side.CLIENT)
public class GuiShieldGenerator
extends GuiContainerMP {
    private static final ResourceLocation TEXTURE = new ResourceLocation("moreplanets:textures/gui/shield_generator.png");
    private final TileEntityShieldGenerator tile;
    private GuiElementInfoRegionMP electricInfoRegion;
    private GuiButton buttonEnable;

    public GuiShieldGenerator(InventoryPlayer inventory, TileEntityShieldGenerator tile) {
        super(new ContainerShieldGenerator(inventory, tile));
        this.tile = tile;
        this.field_146999_f = 201;
        this.field_147000_g = 213;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.tile.func_145831_w()), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 1: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_SWITCH_SHIELD_GENERATOR_GUI, GCCoreUtil.getDimensionID((World)this.tile.func_145831_w()), this.tile.func_174877_v(), true));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.infoRegions.add(new GuiElementInfoRegionMP((x += 12) + 151, y + 77, 18, 18, Arrays.asList(LangUtils.translate((String)"gui.battery_slot.desc.0"), LangUtils.translate((String)"gui.battery_slot.desc.1")), this.field_146294_l, this));
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 176, y + 59, 18, 18, Arrays.asList(LangUtils.translate((String)"gui.shield_capacity_upgrade.desc.0"), LangUtils.translate((String)"gui.shield_capacity_upgrade.desc.1")), this.field_146294_l, this));
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 176, y + 41, 18, 18, Arrays.asList(LangUtils.translate((String)"gui.shield_size_upgrade.desc.0"), LangUtils.translate((String)"gui.shield_size_upgrade.desc.1")), this.field_146294_l, this));
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 176, y + 23, 18, 18, Arrays.asList(LangUtils.translate((String)"gui.shield_damage_upgrade.desc.0"), LangUtils.translate((String)"gui.shield_damage_upgrade.desc.1")), this.field_146294_l, this));
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(LangUtils.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(TextFormatting.YELLOW + LangUtils.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.tile.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tile.getMaxEnergyStoredGC()));
        this.electricInfoRegion = new GuiElementInfoRegionMP(x + 156, y + 21, 8, 43, electricityDesc, this.field_146294_l, this);
        this.infoRegions.add(this.electricInfoRegion);
        this.buttonEnable = new GuiButton(0, this.field_146294_l / 2 - 76, this.field_146295_m / 2 - 6, 72, 20, !this.tile.getDisabled(0) ? LangUtils.translate((String)"gui.button.disable.name") : LangUtils.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnable);
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 6, 72, 20, LangUtils.translate((String)"gui.button.config.name")));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        boolean half1;
        this.buttonEnable.field_146124_l = this.tile.disableCooldown == 0;
        this.buttonEnable.field_146126_j = !this.tile.getDisabled(0) ? LangUtils.translate((String)"gui.button.disable.name") : LangUtils.translate((String)"gui.button.enable.name");
        String owner = "";
        try {
            owner = this.tile.func_145831_w().func_152378_a(UUID.fromString(this.tile.ownerUUID)).func_70005_c_() + "'s ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean half = (float)this.tile.shieldCapacity < (float)this.tile.maxShieldCapacity / 1.25f;
        boolean bl = half1 = (float)this.tile.shieldCapacity < (float)this.tile.maxShieldCapacity / 4.0f;
        TextFormatting color = half1 ? TextFormatting.DARK_RED : (half ? TextFormatting.GOLD : TextFormatting.GREEN);
        ArrayList<String> list = new ArrayList<String>();
        int y = 24;
        list.add(LangUtils.translate((String)"gui.message.status.name") + ": " + this.tile.getStatus());
        list.add(LangUtils.translate((String)"gui.status.shield_damage.name") + ": " + TextFormatting.GREEN + this.tile.shieldDamage);
        list.add(LangUtils.translate((String)"gui.status.shield_size.name") + ": " + TextFormatting.GREEN + this.tile.maxShieldSize);
        list.add(LangUtils.translate((String)"gui.status.shield_capacity.name") + ": " + color + NumberUtils.format((long)this.tile.shieldCapacity) + "/" + NumberUtils.format((long)this.tile.maxShieldCapacity));
        if (this.tile.shieldChargeCooldown > 0) {
            list.add(LangUtils.translate((String)"gui.status.shield_charge_cooldown.name") + ": " + TextFormatting.AQUA + this.tile.shieldChargeCooldown / 20);
        }
        for (String text : list) {
            this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - 79, y, 2536735);
            y += 10;
        }
        this.field_146289_q.func_78276_b(owner + this.tile.func_70005_c_(), 20, 10, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.translate((String)"container.inventory"), 20, this.field_147000_g - 90 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x += 12, y + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        int scale = this.tile.getScaledElecticalLevel(42);
        this.func_73729_b(x + 156, y + 64 - scale, 201, 42 - scale + 10, 8, scale);
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(x + 154, y + 66, 201, 0, 11, 10);
        }
        ArrayList<String> electricityDesc = new ArrayList<String>(Arrays.asList(LangUtils.translate((String)"gui.energy_storage.desc.0")));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
    }
}

