/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.network.SyncDimensionInfoHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class DimensionSyncPacket {
    private final Map<Integer, DimensionDescriptor> dimensions;
    private final Map<Integer, DimensionInformation> dimensionInformation;

    public DimensionSyncPacket() {
        this.dimensions = new HashMap<Integer, DimensionDescriptor>();
        this.dimensionInformation = new HashMap<Integer, DimensionInformation>();
    }

    public DimensionSyncPacket(Map<Integer, DimensionDescriptor> dimensions, Map<Integer, DimensionInformation> dimensionInformation) {
        this.dimensions = dimensions;
        this.dimensionInformation = dimensionInformation;
    }

    public void consumePacket(ByteBuf data) {
        int id;
        int i;
        int size = data.readInt();
        for (i = 0; i < size; ++i) {
            NBTTagCompound tagCompound;
            id = data.readInt();
            PacketBuffer buffer = new PacketBuffer(data);
            try {
                tagCompound = buffer.func_150793_b();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            DimensionDescriptor descriptor = new DimensionDescriptor(tagCompound);
            this.dimensions.put(id, descriptor);
        }
        size = data.readInt();
        for (i = 0; i < size; ++i) {
            id = data.readInt();
            String name = NetworkTools.readString((ByteBuf)data);
            DimensionInformation dimInfo = new DimensionInformation(name, this.dimensions.get(id), data);
            this.dimensionInformation.put(id, dimInfo);
        }
    }

    public ByteBuf getData() {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.dimensions.size());
        for (Map.Entry<Integer, DimensionDescriptor> entry : this.dimensions.entrySet()) {
            data.writeInt(entry.getKey().intValue());
            NBTTagCompound tagCompound = new NBTTagCompound();
            entry.getValue().writeToNBT(tagCompound);
            PacketBuffer buffer = new PacketBuffer(data);
            buffer.func_150786_a(tagCompound);
        }
        data.writeInt(this.dimensionInformation.size());
        for (Map.Entry<Integer, Object> entry : this.dimensionInformation.entrySet()) {
            data.writeInt(entry.getKey().intValue());
            DimensionInformation dimInfo = (DimensionInformation)entry.getValue();
            NetworkTools.writeString((ByteBuf)data, (String)dimInfo.getName());
            dimInfo.toBytes(data);
        }
        return data;
    }

    public void execute() {
        StringBuilder builder = new StringBuilder();
        for (int id : this.dimensions.keySet()) {
            builder.append(id);
            builder.append(' ');
            if (DimensionManager.isDimensionRegistered((int)id)) continue;
            DimensionManager.registerDimension((int)id, (DimensionType)ModDimensions.rftoolsType);
        }
        Logging.log((String)("DimensionSyncPacket: Registering: " + builder.toString()));
        Minecraft.func_71410_x().func_152344_a(() -> SyncDimensionInfoHelper.syncDimensionManagerFromServer(this.dimensions, this.dimensionInformation));
    }
}

